package com.icetech.city.road.domain.table;

import java.math.BigDecimal;
import java.util.Date;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 退款记录表
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("ice_order_refund_record")
public class OrderRefundRecord {

    /**
     * id
     */
    @TableId("id")
    private Long id;

    /**
     * 车场id
     */
    @TableField("park_id")
    private Integer parkId;

    /**
     * 车场退款ID
     */
    @TableField("refund_id")
    private Long refundId;

    /**
     * 订单号
     */
    @TableField("order_num")
    private String orderNum;

    /**
     * 系统交易流水号
     */
    @TableField("trade_no")
    private String tradeNo;

    /**
     * 商户交易流水号
     */
    @TableField("out_trade_no")
    private String outTradeNo;

    /**
     * 车牌号
     */
    @TableField("plate_num")
    private String plateNum;

    /**
     * 退款金额
     */
    @TableField("amount")
    private BigDecimal amount;


    /**
     * 退款交易流水号
     */
    @TableField("refund_trade_no")
    private String refundTradeNo;

    /**
     * 退款状态 -1=已取消 0= 待审核 1=未退款 2=退款中 3=退款成功 4=退款失败
     */
    @TableField("refund_status")
    private Integer refundStatus;

    /**
     * 退款时间
     */
    @TableField("refund_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date refundTime;


    /**
     * 备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 操作人
     */
    @TableField("option_name")
    private String optionName;

    /**
     * 操作时间
     */
    @TableField("option_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date optionTime;

    /**
     * 创建时间
     */
    @TableField("create_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

}