package com.icetech.city.road.domain.table;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;
import java.util.Date;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 月卡操作记录表
 * </p>
 *
 * @author wangzhiwei
 * @since 2021-09-03
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("ice_month_record")
public class MonthRecord implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键自增长id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 月卡id
     */
    private Integer monthId;

    /**
     * 月卡产品id
     */
    private Integer productId;

    /**
     * 申办性质
     */
    private Integer cardProperty;

    /**
     * 月卡所属人姓名/公司名称
     */
    private String cardOwner;

    /**
     * 车牌号多个英文,隔开
     */
    private String plateNum;

    /**
     * 车位号多个英文,隔开
     */
    private String spaceNum;

    /**
     * 手机号码
     */
    private String phone;

    /**
     * 操作类型1 新增 2 续费 3 修改 4 退卡
     */
    private Integer cardOpertype;

    /**
     * 是否逾期(仅当操作类型为2时有效 1 是 0 否
     */
    private Integer isOverdue;

    /**
     * 车位数
     */
    private Integer plotCount;

    /**
     * 购买数量
     */
    private Integer count;

    /**
     * 支付金额
     */
    private BigDecimal payMoney;

    /**
     * 押金
     */
    private BigDecimal deposit;

    /**
     * 支付方式(0 现金，1 银行卡 2：微信 3：支付宝)
     */
    private Integer payMethod;

    /**
     * 退卡金额
     */
    private BigDecimal refund;

    /**
     * 月卡有效开始日期
     */
    private Date startTime;

    /**
     * 月卡有效结束日期
     */
    private Date endTime;

    /**
     * 操作人
     */
    private String operAccount;

    /**
     * 备注
     */
    private String remark;

    /**
     * 月卡暂停实际开始时间,仅操作类型为暂停和恢复时有效
     */
    private Date cardstopStart;

    /**
     * 月卡暂停计划结束时间
     */
    private Date cardstopEnd;

    /**
     * 月卡暂停实际结束时间
     */
    private Date cardstopRealyend;

    /**
     * 月卡额外天数
     */
    private String addDay;

    /**
     * 月卡额外收费
     */
    private BigDecimal addAmount;

    /**
     * 车主地址
     */
    private String mainAddress;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 操作时间
     */
    private Date updateTime;


}
