package com.icetech.city.road.domain.table;

import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 月卡关联车牌号表
 * </p>
 *
 * @author wangzhiwei
 * @since 2021-09-03
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("ice_month_plate")
public class MonthPlate implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键自增长id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 月卡id
     */
    private Integer monthId;

    /**
     * 车牌号
     */
    private String plateNum;

    /**
     * 姓名
     */
    private String owner;


}
