package com.icetech.city.road.domain.table;

import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * 限号设置表
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author fangct
 * @version 1.0 @date 2024-12-02
 */
@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
@TableName("ice_limit_config")
public class LimitConfig implements Serializable {

    private static final long serialVersionUID=1L;

    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 周一限行信息，尾号限行填写比如：4,9
     */
    private String limitDriveNum1;

    /**
     * 周二限行信息，尾号限行填写比如：5,0
     */
    private String limitDriveNum2;

    /**
     * 周三限行信息，尾号限行填写：1,6
     */
    private String limitDriveNum3;

    /**
     * 周四限行信息，尾号限行填写：2,7
     */
    private String limitDriveNum4;

    /**
     * 周五限行信息，尾号限行填写：3,8
     */
    private String limitDriveNum5;

    /**
     * 周五限行信息，尾号限行填写：3,8
     */
    private String limitDriveNum6;

    /**
     * 周五限行信息，尾号限行填写：3,8
     */
    private String limitDriveNum7;

    /**
     * 限号周期开始时间
     */
    private Date limitStartTime;

    /**
     * 限号周期结束时间
     */
    private Date limitEndTime;

    /**
     * 状态（0：正常，1：删除，默认0）
     */
    private Integer deleteStatus;

    /**
     * 添加时间
     */
    @TableField(fill = FieldFill.INSERT)
    private Date createTime;

    /**
     * 操作人
     */
    private String addUser;

    /**
     * 修改时间
     */
    @TableField(fill = FieldFill.UPDATE)
    private Date updateTime;

    /**
     * 更新人
     */
    private String updateUser;


}
