package com.icetech.city.road.domain.table;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.icetech.city.road.component.jackson.TemporalFormat;
import com.icetech.city.road.utils.DateUtils;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
@TableName("ice_empe_atte_record")
public class EmpeAtteRecord implements Serializable {
    /** ID */
    @TableId("id")
    protected Long id;
    /** 考勤分组ID */
    @TableField("group_id")
    protected Long groupId;
    /** 考勤分组名称 */
    @TableField("group_name")
    protected String groupName;
    /** 考勤班次ID */
    @TableField("class_id")
    protected Long classId;
    /** 考勤班次名称 */
    @TableField("class_name")
    protected String className;
    /** 班次开始时间 */
    @TableField("class_begin_time")
    @JsonFormat(pattern = DateUtils.DEFAULT_TIME_HM_PATTERN)
    @TemporalFormat(pattern = DateUtils.DEFAULT_TIME_HM_PATTERN)
    protected LocalTime classBeginTime;
    /** 班次结束时间 */
    @TableField("class_end_time")
    @JsonFormat(pattern = DateUtils.DEFAULT_TIME_HM_PATTERN)
    @TemporalFormat(pattern = DateUtils.DEFAULT_TIME_HM_PATTERN)
    protected LocalTime classEndTime;
    /** 考勤计划ID */
    @TableField("plan_id")
    protected Long planId;
    /** 考勤计划日期 */
    @TableField("plan_date")
    @JsonFormat(pattern = DateUtils.DEFAULT_DATE_PATTERN)
    @TemporalFormat(pattern = DateUtils.DEFAULT_DATE_PATTERN)
    protected LocalDate planDate;
    /** 车场ID */
    @TableField("park_id")
    protected Long parkId;
    /** 车场名称 */
    @TableField("park_name")
    protected String parkName;
    /** 员工ID */
    @TableField("empe_id")
    protected Long empeId;
    /** 员工姓名 */
    @TableField("empe_name")
    protected String empeName;
    /** 班次出勤时间 */
    @TableField("atte_time")
    @JsonFormat(pattern = DateUtils.DEFAULT_DATETIME_PATTERN)
    @TemporalFormat(pattern = DateUtils.DEFAULT_DATETIME_PATTERN)
    protected LocalDateTime atteTime;
    /** 打卡类型(1-签到;2-签退) */
    @TableField("check_type")
    protected Integer checkType;
    /** 打卡时间 */
    @TableField("check_time")
    @JsonFormat(pattern = DateUtils.DEFAULT_DATETIME_PATTERN)
    @TemporalFormat(pattern = DateUtils.DEFAULT_DATETIME_PATTERN)
    protected LocalDateTime checkTime;
    /** 打卡设备类型(1-POS机) */
    @TableField("device_type")
    protected Integer deviceType;
    /** 打卡设备号 */
    @TableField("device_sn")
    protected String deviceSn;
    /** 打卡经度 */
    @TableField("check_lon")
    protected Double checkLon;
    /** 打卡纬度 */
    @TableField("check_lat")
    protected Double checkLat;
    /** 打卡地址 */
    @TableField("check_addr")
    protected String checkAddr;
    /** 打卡结果(0-成功;1-迟到;2-早退;3-超范围;4-未打卡) */
    @TableField("check_result")
    protected Integer checkResult;
    /** 违规时长(迟到/早退, 秒) */
    protected Integer vionDuration;
    /** 创建时间 */
    @TableField("create_time")
    @JsonFormat(pattern = DateUtils.DEFAULT_DATETIME_PATTERN)
    @TemporalFormat(pattern = DateUtils.DEFAULT_DATETIME_PATTERN)
    protected LocalDateTime createTime;
}
