package com.icetech.city.road.domain.table;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.icetech.city.road.component.jackson.TemporalFormat;
import com.icetech.city.road.utils.DateUtils;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

import static com.icetech.city.road.utils.DateUtils.DEFAULT_DATE_PATTERN;

@Getter
@Setter
@ToString
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
@TableName("ice_empe_atte_plan")
public class EmpeAttePlan implements Serializable {
    /** ID */
    @TableId("id")
    protected Long id;
    /** 分组ID */
    @TableField(value = "group_id", updateStrategy = FieldStrategy.NEVER)
    protected Long groupId;
    /** 班次ID */
    @TableField(value = "class_id", updateStrategy = FieldStrategy.NEVER)
    protected Long classId;
    /** 考勤车场ID */
    @TableField(value = "park_id", updateStrategy = FieldStrategy.NEVER)
    protected Long parkId;
    /** 计划日期 */
    @TableField(value = "plan_date", updateStrategy = FieldStrategy.NEVER)
    @JsonFormat(pattern = DEFAULT_DATE_PATTERN)
    @TemporalFormat(pattern = DateUtils.DEFAULT_DATE_PATTERN)
    protected LocalDate planDate;
    /** 开始时间 */
    @TableField(value = "begin_date_time")
    @JsonFormat(pattern = DateUtils.DEFAULT_DATETIME_PATTERN)
    @TemporalFormat(pattern = DateUtils.DEFAULT_DATETIME_PATTERN)
    protected LocalDateTime beginDateTime;
    /** 结束时间 */
    @TableField(value = "end_date_time")
    @JsonFormat(pattern = DateUtils.DEFAULT_DATETIME_PATTERN)
    @TemporalFormat(pattern = DateUtils.DEFAULT_DATETIME_PATTERN)
    protected LocalDateTime endDateTime;
    /** 员工ID */
    @TableField("empe_id")
    protected Long empeId;
    /** 创建人 */
    @TableField(value = "create_user", updateStrategy = FieldStrategy.NEVER)
    protected String createUser;
    /** 创建时间 */
    @TableField(value = "create_time", updateStrategy = FieldStrategy.NEVER)
    @JsonFormat(pattern = DateUtils.DEFAULT_DATETIME_PATTERN)
    @TemporalFormat(pattern = DateUtils.DEFAULT_DATETIME_PATTERN)
    protected LocalDateTime createTime;
    /** 修改人 */
    @TableField("update_user")
    protected String updateUser;
    /** 修改时间 */
    @TableField("update_time")
    @JsonFormat(pattern = DateUtils.DEFAULT_DATETIME_PATTERN)
    @TemporalFormat(pattern = DateUtils.DEFAULT_DATETIME_PATTERN)
    protected LocalDateTime updateTime;

    /** 考勤年份 */
    @TableField(exist = false)
    protected Integer atteYear;
    /** 考勤月份 */
    @TableField(exist = false)
    protected Integer atteMonth;
    /** 考勤月日期 */
    @TableField(exist = false)
    protected Integer atteDay;

    public EmpeAttePlan setPlanDate(LocalDate planDate) {
        this.planDate = planDate;
        if (planDate != null) {
            setAtteYear(planDate.getYear());
            setAtteMonth(planDate.getMonthValue());
            setAtteDay(planDate.getDayOfMonth());
        }
        return this;
    }

    public EmpeAttePlan planDateTime(LocalDate planDate, LocalTime beginTime, LocalTime endTime) {
        setPlanDate(planDate);
        setBeginDateTime(planDate.atTime(beginTime));
        setEndDateTime(endTime.atDate(beginTime.isBefore(endTime) ? planDate : planDate.plusDays(1)));
        return this;
    }
}
