package com.icetech.city.road.domain.table;

import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;

import java.io.Serializable;
import java.util.Date;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * POS机设备表
 * </p>
 *
 * @author wangzhiwei
 * @since 2021-03-04
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("ice_dev_pos")
public class DevPos implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键自增长id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 设备编号
     */
    private String devCode;
    /**
     * 车场id
     */
    private Integer parkId;

    /**
     * 设备名称
     */
    private String devName;

    /**
     * 所属停车区id
     */
    private Integer regionId;

    /**
     * 设备型号（设备厂家型号表id）
     */
    private Integer devModel;

    /**
     * 设备序列号（MAC）
     */
    private String devSerialnumber;

    /**
     * 设备状态（1：正常，2：离线，3：故障，默认2）
     */
    private Integer devStatus;

    /**
     * 设备联系人
     */
    private String devOwner;

    /**
     * 剩余电量
     */
    private Double remainingCapacity;

    /**
     * 最后一次心跳时间（时间戳）
     */
    private Long heartbeatTime;

    /**
     * 注册标识(0-未注册;1-已注册)
     */
    private Integer registerFlag;

    /**
     * 添加时间
     */
    private Date createTime;

    /**
     * 添加人
     */
    private String adder;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 更新人
     */
    private String updateUser;

    /**
     * 描述信息
     */
    private String remark;


}
