package com.icetech.city.road.domain.entity.dto;

import java.util.List;

import com.icetech.city.road.domain.table.Park;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString(callSuper = true)
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
public class EmpeWorkAggrMonthDto {
    /** 车场聚合列表 */
    protected String parkGroup;
    /** 员工ID */
    protected Long empeId;
    /** 员工登录 */
    protected String empeUsername;
    /** 员工名称 */
    protected String empeName;
    /** 统计年月 */
    protected String aggrYearMonth;
    /** 迟到时长(秒) */
    protected Long comeLateDuration;
    /** 早退时长(秒) */
    protected Long leaveEarlyDuration;
    /** 在线时长(秒) */
    protected Long onlineDuration;
    /** 离线时长(秒) */
    protected Long offlineDuration;
    /** 工作时长(秒) */
    protected Long workDuration;

    /** 车场列表 */
    protected List<Park> parks;
}
