package com.icetech.city.road.domain.constant;

import java.util.HashMap;
import java.util.Map;

/**
 * 订单支付状态
 * @author wangzhiwei
 */
public interface OrderPayStatusConstant {
    /** 未交费 */
    int NO_PAY_VAL = 1;
    /** 预交费中 */
    int ADVANCE_PAY_VAL = 2;
    /** 欠费 */
    int NEED_PAY_VAL = 3;
    /** 已缴费 */
    int ALREADY_PAY_VAL = 4;
    /** 无需缴费 */
    int NO_HAS_PAY_VAL = 5;
    /** 未知 */
    int UNKNOWN_PAY_VAL = 6;

    /** 未交费 */
    Integer NO_PAY = NO_PAY_VAL;
    /** 预交费中 */
    Integer ADVANCE_PAY = ADVANCE_PAY_VAL;
    /** 欠费 */
    Integer NEED_PAY = NEED_PAY_VAL;
    /** 已缴费 */
    Integer ALREADY_PAY = ALREADY_PAY_VAL;
    /** 无需缴费 */
    Integer NO_HAS_PAY = NO_HAS_PAY_VAL;
    /** 未知 */
    Integer UNKNOWN_PAY = UNKNOWN_PAY_VAL;

    Map<Integer, String> map = new HashMap<Integer, String>() {{
        put(NO_PAY, "未交费");
        put(ADVANCE_PAY, "预交费中");
        put(NEED_PAY, "欠费");
        put(ALREADY_PAY, "已缴费");
        put(NO_HAS_PAY, "无需缴费");
        put(UNKNOWN_PAY, "未知");
    }};
    static String desc(Integer payStatus){
        return map.get(payStatus);
    }
}
