package com.icetech.city.road.component.bean;

import java.io.Serializable;

import com.icetech.city.road.component.constant.CodeConstants;
import com.icetech.city.road.component.constant.CodeConstantsEnum;
import com.icetech.city.road.component.exception.ResponseBodyException;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

@Getter
@Setter
@ToString
public class Response implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String code;
    protected String msg;

    public static void notError(Response response) {
        if (response == null) {
            throw new ResponseBodyException(CodeConstantsEnum.ERROR);
        }
        if (!CodeConstants.SUCCESS.equals(response.getCode())) {
            throw new ResponseBodyException(response.getCode(), response.getMsg());
        }
    }

    public static void notError(Response response, String msg) {
        if (response == null) {
            throw new ResponseBodyException(CodeConstants.ERROR,
                    msg == null ? CodeConstants.getName(CodeConstants.ERROR) : msg);
        }
        if (!CodeConstants.SUCCESS.equals(response.getCode())) {
            throw new ResponseBodyException(response.getCode(),
                    msg == null ? response.getMsg() : msg);
        }
    }

    public static boolean isSuccess(Response response) {
        return response != null && CodeConstants.SUCCESS.equals(response.getCode());
    }
}
