/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.city.road.utils;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import org.apache.commons.lang3.StringUtils;

public class NumberUtils
extends org.apache.commons.lang3.math.NumberUtils {
    public static final BigDecimal DECIMAL_HUNDRED = new BigDecimal(100);
    public static char[] RADIX_58 = "0123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnpqrstuvwxyz".toCharArray();
    public static char[] RADIX_59 = "0123456789abcdefghijkmnopqrstuvwxyzABCDEFGHJKLMNPQRSTUVWXYZ".toCharArray();
    public static char[] RADIX_62 = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();

    public static int toPrimitive(Integer value) {
        return NumberUtils.toPrimitive(value, 0);
    }

    public static int toPrimitive(Integer value, int defaultValue) {
        return value == null ? defaultValue : value;
    }

    public static long toPrimitive(Long value) {
        return NumberUtils.toPrimitive(value, 0L);
    }

    public static long toPrimitive(Long value, long defaultValue) {
        return value == null ? defaultValue : value;
    }

    public static float toPrimitive(Float value) {
        return value == null ? 0.0f : value.floatValue();
    }

    public static double toPrimitive(Double value) {
        return value == null ? 0.0 : value;
    }

    public static float parseFloat(Object value) {
        if (value == null) {
            return 0.0f;
        }
        String content = value.toString();
        if (StringUtils.isBlank((CharSequence)content)) {
            return 0.0f;
        }
        return Float.parseFloat(content);
    }

    public static float parseFloat(Object value, String pattern) {
        DecimalFormat format = new DecimalFormat(pattern);
        return NumberUtils.parseFloat(format.format(NumberUtils.parseFloat(value)));
    }

    public static double parseDouble(Object value) {
        if (value == null) {
            return 0.0;
        }
        String content = value.toString();
        if (StringUtils.isBlank((CharSequence)content)) {
            return 0.0;
        }
        return Double.parseDouble(content);
    }

    public static double parseDouble(Object value, String pattern) {
        DecimalFormat format = new DecimalFormat(pattern);
        return NumberUtils.parseDouble(format.format(NumberUtils.parseDouble(value)));
    }

    public static String parseString(Object value, String pattern) {
        DecimalFormat format = new DecimalFormat(pattern);
        return format.format(NumberUtils.parseDouble(value));
    }

    public static BigDecimal decimalDivideScale(int scale, RoundingMode mode, Object num, Object ... nums) {
        return NumberUtils.decimalCalculate((decimal1, decimal2) -> decimal1.divide(decimal2, scale, mode), num, nums);
    }

    private static BigDecimal decimalCalculate(DecimalCalculation calculation, Object num, Object ... nums) {
        BigDecimal decimal = NumberUtils.parseDecimal(num, BigDecimal.ZERO);
        if (nums != null && nums.length != 0) {
            for (int i = 0; i < nums.length; ++i) {
                BigDecimal middle = NumberUtils.parseDecimal(nums[i], null);
                if (middle == null) continue;
                decimal = calculation.calculate(decimal, middle);
            }
            return decimal;
        }
        return decimal;
    }

    public static BigDecimal parseDecimal(Object value, BigDecimal defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof Double) {
            return BigDecimal.valueOf((Double)value);
        }
        if (value instanceof Float) {
            return new BigDecimal(Float.toString(((Float)value).floatValue()));
        }
        if (value instanceof Long) {
            return new BigDecimal((Long)value);
        }
        if (value instanceof Integer) {
            return new BigDecimal((Integer)value);
        }
        if (value instanceof Short) {
            return new BigDecimal(((Short)value).shortValue());
        }
        String middle = value.toString().trim();
        return middle.isEmpty() ? defaultValue : new BigDecimal(middle);
    }

    public static BigDecimal decimalSubtract(Object num, Object ... nums) {
        return NumberUtils.decimalCalculate(BigDecimal::subtract, num, nums);
    }

    public static BigDecimal decimalAdd(Object num, Object ... nums) {
        return NumberUtils.decimalCalculate(BigDecimal::add, num, nums);
    }

    public static <T extends Comparable<T>> T min(T t1, T t2) {
        return t1.compareTo(t2) <= 0 ? t1 : t2;
    }

    public static <T extends Comparable<T>> T max(T t1, T t2) {
        return t1.compareTo(t2) >= 0 ? t1 : t2;
    }

    public static String radix59(BigInteger value) {
        return NumberUtils.radix(value, RADIX_59);
    }

    public static String radix62(BigInteger value) {
        return NumberUtils.radix(value, RADIX_62);
    }

    public static String radix(BigInteger value, char[] chars) {
        BigInteger[] values;
        StringBuilder builder = new StringBuilder();
        BigInteger divider = BigInteger.valueOf(chars.length);
        do {
            values = value.divideAndRemainder(divider);
            builder.append(chars[values[1].intValue()]);
        } while ((value = values[0]).compareTo(BigInteger.ZERO) > 0);
        return builder.reverse().toString();
    }

    public static BigInteger radixOf(String value, char[] chars) {
        BigInteger result = BigInteger.ZERO;
        char[] values = value.toCharArray();
        int valueLength = values.length;
        BigInteger radix = BigInteger.valueOf(chars.length);
        int index = 0;
        int r = valueLength - 1;
        while (index < valueLength) {
            char val = values[r];
            for (int i = 0; i < chars.length; ++i) {
                if (chars[i] != val) continue;
                BigInteger step = radix.pow(index).multiply(new BigInteger(String.valueOf(i)));
                result = result.add(step);
                break;
            }
            ++index;
            --r;
        }
        return result;
    }

    private static interface DecimalCalculation {
        public BigDecimal calculate(BigDecimal var1, BigDecimal var2);
    }
}

