/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.city.road.domain.table;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.icetech.city.road.component.jackson.TemporalFormat;
import com.icetech.city.road.domain.entity.dto.CardTypeDto;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Date;
import lombok.Generated;

@TableName(value="ice_order")
public class Order
implements Serializable {
    private static final long serialVersionUID = 1L;
    @TableId(value="id", type=IdType.AUTO)
    private Long id;
    private Integer parkId;
    private String orderNum;
    private String vendorRecordId;
    private Integer berthId;
    private String plateNum;
    private Integer cardType;
    private Integer cardTypeId;
    private Long enterTime;
    private Long exitTime;
    private Integer parkDuration;
    private Long reportTime;
    private Integer carType;
    private BigDecimal totalPrice;
    private BigDecimal paidPrice;
    private BigDecimal unpaidPrice;
    private BigDecimal discountPrice;
    private BigDecimal refundPrice;
    private Integer refundFlag;
    private Integer orderType;
    private Integer orderStatus;
    private String errorCauses;
    private Integer payStatus;
    private Integer enterWay;
    private String enterDevice;
    private Integer exitWay;
    private String exitDevice;
    private Integer plateColor;
    @TableField(value="`push_enter_result`")
    private Integer pushEnterResult;
    @TableField(value="`push_exit_result`")
    private Integer pushExitResult;
    @TableField(updateStrategy=FieldStrategy.NEVER)
    private Date createTime;
    @TableField(updateStrategy=FieldStrategy.NEVER)
    private String adder;
    private Date updateTime;
    private String updateUser;
    private String remark;
    private Integer recoveryFlag;
    @TableField(exist=false)
    private String parkCode;
    @TableField(exist=false)
    private String parkName;
    private Integer invoiceStatus;
    private String lastPrintUser;
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @TemporalFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private LocalDateTime lastPrintTime;
    @TableField(exist=false)
    private String berthCode;
    @TableField(exist=false)
    protected String enterVideo;
    @TableField(exist=false)
    protected String exitVideo;
    @TableField(exist=false)
    protected CardTypeDto cardTypeDto;

    public Order setDiscountPrice(BigDecimal discountPrice) {
        this.discountPrice = this.checkValue(discountPrice);
        return this;
    }

    public Order setUnpaidPrice(BigDecimal unpaidPrice) {
        this.unpaidPrice = this.checkValue(unpaidPrice);
        return this;
    }

    public Order setPaidPrice(BigDecimal paidPrice) {
        this.paidPrice = this.checkValue(paidPrice);
        return this;
    }

    public Order setTotalPrice(BigDecimal totalPrice) {
        this.totalPrice = this.checkValue(totalPrice);
        return this;
    }

    public Order setRefundPrice(BigDecimal refundPrice) {
        this.refundPrice = this.checkValue(refundPrice);
        return this;
    }

    private BigDecimal checkValue(BigDecimal value) {
        if (value == null || value.compareTo(BigDecimal.ZERO) < 0) {
            return BigDecimal.ZERO;
        }
        return value;
    }

    public Order setExitTimeWithDuration(Long exitTime) {
        return this.setExitTimeWithDuration(exitTime, this.enterTime);
    }

    public Order setExitTimeWithDuration(Long exitTime, Long enterTime) {
        this.setExitTime(exitTime);
        this.calcParkDuration(enterTime, exitTime);
        return this;
    }

    public Order calcParkDuration() {
        if (this.enterTime != null && this.exitTime != null) {
            this.calcParkDuration(this.enterTime, this.exitTime);
        }
        return this;
    }

    public Order calcParkDuration(Long enterTime, Long exitTime) {
        this.setParkDuration((int)(exitTime - enterTime));
        return this;
    }

    @Generated
    public Order() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Integer getParkId() {
        return this.parkId;
    }

    @Generated
    public String getOrderNum() {
        return this.orderNum;
    }

    @Generated
    public String getVendorRecordId() {
        return this.vendorRecordId;
    }

    @Generated
    public Integer getBerthId() {
        return this.berthId;
    }

    @Generated
    public String getPlateNum() {
        return this.plateNum;
    }

    @Generated
    public Integer getCardType() {
        return this.cardType;
    }

    @Generated
    public Integer getCardTypeId() {
        return this.cardTypeId;
    }

    @Generated
    public Long getEnterTime() {
        return this.enterTime;
    }

    @Generated
    public Long getExitTime() {
        return this.exitTime;
    }

    @Generated
    public Integer getParkDuration() {
        return this.parkDuration;
    }

    @Generated
    public Long getReportTime() {
        return this.reportTime;
    }

    @Generated
    public Integer getCarType() {
        return this.carType;
    }

    @Generated
    public BigDecimal getTotalPrice() {
        return this.totalPrice;
    }

    @Generated
    public BigDecimal getPaidPrice() {
        return this.paidPrice;
    }

    @Generated
    public BigDecimal getUnpaidPrice() {
        return this.unpaidPrice;
    }

    @Generated
    public BigDecimal getDiscountPrice() {
        return this.discountPrice;
    }

    @Generated
    public BigDecimal getRefundPrice() {
        return this.refundPrice;
    }

    @Generated
    public Integer getRefundFlag() {
        return this.refundFlag;
    }

    @Generated
    public Integer getOrderType() {
        return this.orderType;
    }

    @Generated
    public Integer getOrderStatus() {
        return this.orderStatus;
    }

    @Generated
    public String getErrorCauses() {
        return this.errorCauses;
    }

    @Generated
    public Integer getPayStatus() {
        return this.payStatus;
    }

    @Generated
    public Integer getEnterWay() {
        return this.enterWay;
    }

    @Generated
    public String getEnterDevice() {
        return this.enterDevice;
    }

    @Generated
    public Integer getExitWay() {
        return this.exitWay;
    }

    @Generated
    public String getExitDevice() {
        return this.exitDevice;
    }

    @Generated
    public Integer getPlateColor() {
        return this.plateColor;
    }

    @Generated
    public Integer getPushEnterResult() {
        return this.pushEnterResult;
    }

    @Generated
    public Integer getPushExitResult() {
        return this.pushExitResult;
    }

    @Generated
    public Date getCreateTime() {
        return this.createTime;
    }

    @Generated
    public String getAdder() {
        return this.adder;
    }

    @Generated
    public Date getUpdateTime() {
        return this.updateTime;
    }

    @Generated
    public String getUpdateUser() {
        return this.updateUser;
    }

    @Generated
    public String getRemark() {
        return this.remark;
    }

    @Generated
    public Integer getRecoveryFlag() {
        return this.recoveryFlag;
    }

    @Generated
    public String getParkCode() {
        return this.parkCode;
    }

    @Generated
    public String getParkName() {
        return this.parkName;
    }

    @Generated
    public Integer getInvoiceStatus() {
        return this.invoiceStatus;
    }

    @Generated
    public String getLastPrintUser() {
        return this.lastPrintUser;
    }

    @Generated
    public LocalDateTime getLastPrintTime() {
        return this.lastPrintTime;
    }

    @Generated
    public String getBerthCode() {
        return this.berthCode;
    }

    @Generated
    public String getEnterVideo() {
        return this.enterVideo;
    }

    @Generated
    public String getExitVideo() {
        return this.exitVideo;
    }

    @Generated
    public CardTypeDto getCardTypeDto() {
        return this.cardTypeDto;
    }

    @Generated
    public Order setId(Long id) {
        this.id = id;
        return this;
    }

    @Generated
    public Order setParkId(Integer parkId) {
        this.parkId = parkId;
        return this;
    }

    @Generated
    public Order setOrderNum(String orderNum) {
        this.orderNum = orderNum;
        return this;
    }

    @Generated
    public Order setVendorRecordId(String vendorRecordId) {
        this.vendorRecordId = vendorRecordId;
        return this;
    }

    @Generated
    public Order setBerthId(Integer berthId) {
        this.berthId = berthId;
        return this;
    }

    @Generated
    public Order setPlateNum(String plateNum) {
        this.plateNum = plateNum;
        return this;
    }

    @Generated
    public Order setCardType(Integer cardType) {
        this.cardType = cardType;
        return this;
    }

    @Generated
    public Order setCardTypeId(Integer cardTypeId) {
        this.cardTypeId = cardTypeId;
        return this;
    }

    @Generated
    public Order setEnterTime(Long enterTime) {
        this.enterTime = enterTime;
        return this;
    }

    @Generated
    public Order setExitTime(Long exitTime) {
        this.exitTime = exitTime;
        return this;
    }

    @Generated
    public Order setParkDuration(Integer parkDuration) {
        this.parkDuration = parkDuration;
        return this;
    }

    @Generated
    public Order setReportTime(Long reportTime) {
        this.reportTime = reportTime;
        return this;
    }

    @Generated
    public Order setCarType(Integer carType) {
        this.carType = carType;
        return this;
    }

    @Generated
    public Order setRefundFlag(Integer refundFlag) {
        this.refundFlag = refundFlag;
        return this;
    }

    @Generated
    public Order setOrderType(Integer orderType) {
        this.orderType = orderType;
        return this;
    }

    @Generated
    public Order setOrderStatus(Integer orderStatus) {
        this.orderStatus = orderStatus;
        return this;
    }

    @Generated
    public Order setErrorCauses(String errorCauses) {
        this.errorCauses = errorCauses;
        return this;
    }

    @Generated
    public Order setPayStatus(Integer payStatus) {
        this.payStatus = payStatus;
        return this;
    }

    @Generated
    public Order setEnterWay(Integer enterWay) {
        this.enterWay = enterWay;
        return this;
    }

    @Generated
    public Order setEnterDevice(String enterDevice) {
        this.enterDevice = enterDevice;
        return this;
    }

    @Generated
    public Order setExitWay(Integer exitWay) {
        this.exitWay = exitWay;
        return this;
    }

    @Generated
    public Order setExitDevice(String exitDevice) {
        this.exitDevice = exitDevice;
        return this;
    }

    @Generated
    public Order setPlateColor(Integer plateColor) {
        this.plateColor = plateColor;
        return this;
    }

    @Generated
    public Order setPushEnterResult(Integer pushEnterResult) {
        this.pushEnterResult = pushEnterResult;
        return this;
    }

    @Generated
    public Order setPushExitResult(Integer pushExitResult) {
        this.pushExitResult = pushExitResult;
        return this;
    }

    @Generated
    public Order setCreateTime(Date createTime) {
        this.createTime = createTime;
        return this;
    }

    @Generated
    public Order setAdder(String adder) {
        this.adder = adder;
        return this;
    }

    @Generated
    public Order setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
        return this;
    }

    @Generated
    public Order setUpdateUser(String updateUser) {
        this.updateUser = updateUser;
        return this;
    }

    @Generated
    public Order setRemark(String remark) {
        this.remark = remark;
        return this;
    }

    @Generated
    public Order setRecoveryFlag(Integer recoveryFlag) {
        this.recoveryFlag = recoveryFlag;
        return this;
    }

    @Generated
    public Order setParkCode(String parkCode) {
        this.parkCode = parkCode;
        return this;
    }

    @Generated
    public Order setParkName(String parkName) {
        this.parkName = parkName;
        return this;
    }

    @Generated
    public Order setInvoiceStatus(Integer invoiceStatus) {
        this.invoiceStatus = invoiceStatus;
        return this;
    }

    @Generated
    public Order setLastPrintUser(String lastPrintUser) {
        this.lastPrintUser = lastPrintUser;
        return this;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Generated
    public Order setLastPrintTime(LocalDateTime lastPrintTime) {
        this.lastPrintTime = lastPrintTime;
        return this;
    }

    @Generated
    public Order setBerthCode(String berthCode) {
        this.berthCode = berthCode;
        return this;
    }

    @Generated
    public Order setEnterVideo(String enterVideo) {
        this.enterVideo = enterVideo;
        return this;
    }

    @Generated
    public Order setExitVideo(String exitVideo) {
        this.exitVideo = exitVideo;
        return this;
    }

    @Generated
    public Order setCardTypeDto(CardTypeDto cardTypeDto) {
        this.cardTypeDto = cardTypeDto;
        return this;
    }

    @Generated
    public String toString() {
        return "Order(id=" + this.getId() + ", parkId=" + this.getParkId() + ", orderNum=" + this.getOrderNum() + ", vendorRecordId=" + this.getVendorRecordId() + ", berthId=" + this.getBerthId() + ", plateNum=" + this.getPlateNum() + ", cardType=" + this.getCardType() + ", cardTypeId=" + this.getCardTypeId() + ", enterTime=" + this.getEnterTime() + ", exitTime=" + this.getExitTime() + ", parkDuration=" + this.getParkDuration() + ", reportTime=" + this.getReportTime() + ", carType=" + this.getCarType() + ", totalPrice=" + this.getTotalPrice() + ", paidPrice=" + this.getPaidPrice() + ", unpaidPrice=" + this.getUnpaidPrice() + ", discountPrice=" + this.getDiscountPrice() + ", refundPrice=" + this.getRefundPrice() + ", refundFlag=" + this.getRefundFlag() + ", orderType=" + this.getOrderType() + ", orderStatus=" + this.getOrderStatus() + ", errorCauses=" + this.getErrorCauses() + ", payStatus=" + this.getPayStatus() + ", enterWay=" + this.getEnterWay() + ", enterDevice=" + this.getEnterDevice() + ", exitWay=" + this.getExitWay() + ", exitDevice=" + this.getExitDevice() + ", plateColor=" + this.getPlateColor() + ", pushEnterResult=" + this.getPushEnterResult() + ", pushExitResult=" + this.getPushExitResult() + ", createTime=" + this.getCreateTime() + ", adder=" + this.getAdder() + ", updateTime=" + this.getUpdateTime() + ", updateUser=" + this.getUpdateUser() + ", remark=" + this.getRemark() + ", recoveryFlag=" + this.getRecoveryFlag() + ", parkCode=" + this.getParkCode() + ", parkName=" + this.getParkName() + ", invoiceStatus=" + this.getInvoiceStatus() + ", lastPrintUser=" + this.getLastPrintUser() + ", lastPrintTime=" + this.getLastPrintTime() + ", berthCode=" + this.getBerthCode() + ", enterVideo=" + this.getEnterVideo() + ", exitVideo=" + this.getExitVideo() + ", cardTypeDto=" + this.getCardTypeDto() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Order)) {
            return false;
        }
        Order other = (Order)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$parkId = this.getParkId();
        Integer other$parkId = other.getParkId();
        if (this$parkId == null ? other$parkId != null : !((Object)this$parkId).equals(other$parkId)) {
            return false;
        }
        Integer this$berthId = this.getBerthId();
        Integer other$berthId = other.getBerthId();
        if (this$berthId == null ? other$berthId != null : !((Object)this$berthId).equals(other$berthId)) {
            return false;
        }
        Integer this$cardType = this.getCardType();
        Integer other$cardType = other.getCardType();
        if (this$cardType == null ? other$cardType != null : !((Object)this$cardType).equals(other$cardType)) {
            return false;
        }
        Integer this$cardTypeId = this.getCardTypeId();
        Integer other$cardTypeId = other.getCardTypeId();
        if (this$cardTypeId == null ? other$cardTypeId != null : !((Object)this$cardTypeId).equals(other$cardTypeId)) {
            return false;
        }
        Long this$enterTime = this.getEnterTime();
        Long other$enterTime = other.getEnterTime();
        if (this$enterTime == null ? other$enterTime != null : !((Object)this$enterTime).equals(other$enterTime)) {
            return false;
        }
        Long this$exitTime = this.getExitTime();
        Long other$exitTime = other.getExitTime();
        if (this$exitTime == null ? other$exitTime != null : !((Object)this$exitTime).equals(other$exitTime)) {
            return false;
        }
        Integer this$parkDuration = this.getParkDuration();
        Integer other$parkDuration = other.getParkDuration();
        if (this$parkDuration == null ? other$parkDuration != null : !((Object)this$parkDuration).equals(other$parkDuration)) {
            return false;
        }
        Long this$reportTime = this.getReportTime();
        Long other$reportTime = other.getReportTime();
        if (this$reportTime == null ? other$reportTime != null : !((Object)this$reportTime).equals(other$reportTime)) {
            return false;
        }
        Integer this$carType = this.getCarType();
        Integer other$carType = other.getCarType();
        if (this$carType == null ? other$carType != null : !((Object)this$carType).equals(other$carType)) {
            return false;
        }
        Integer this$refundFlag = this.getRefundFlag();
        Integer other$refundFlag = other.getRefundFlag();
        if (this$refundFlag == null ? other$refundFlag != null : !((Object)this$refundFlag).equals(other$refundFlag)) {
            return false;
        }
        Integer this$orderType = this.getOrderType();
        Integer other$orderType = other.getOrderType();
        if (this$orderType == null ? other$orderType != null : !((Object)this$orderType).equals(other$orderType)) {
            return false;
        }
        Integer this$orderStatus = this.getOrderStatus();
        Integer other$orderStatus = other.getOrderStatus();
        if (this$orderStatus == null ? other$orderStatus != null : !((Object)this$orderStatus).equals(other$orderStatus)) {
            return false;
        }
        Integer this$payStatus = this.getPayStatus();
        Integer other$payStatus = other.getPayStatus();
        if (this$payStatus == null ? other$payStatus != null : !((Object)this$payStatus).equals(other$payStatus)) {
            return false;
        }
        Integer this$enterWay = this.getEnterWay();
        Integer other$enterWay = other.getEnterWay();
        if (this$enterWay == null ? other$enterWay != null : !((Object)this$enterWay).equals(other$enterWay)) {
            return false;
        }
        Integer this$exitWay = this.getExitWay();
        Integer other$exitWay = other.getExitWay();
        if (this$exitWay == null ? other$exitWay != null : !((Object)this$exitWay).equals(other$exitWay)) {
            return false;
        }
        Integer this$plateColor = this.getPlateColor();
        Integer other$plateColor = other.getPlateColor();
        if (this$plateColor == null ? other$plateColor != null : !((Object)this$plateColor).equals(other$plateColor)) {
            return false;
        }
        Integer this$pushEnterResult = this.getPushEnterResult();
        Integer other$pushEnterResult = other.getPushEnterResult();
        if (this$pushEnterResult == null ? other$pushEnterResult != null : !((Object)this$pushEnterResult).equals(other$pushEnterResult)) {
            return false;
        }
        Integer this$pushExitResult = this.getPushExitResult();
        Integer other$pushExitResult = other.getPushExitResult();
        if (this$pushExitResult == null ? other$pushExitResult != null : !((Object)this$pushExitResult).equals(other$pushExitResult)) {
            return false;
        }
        Integer this$recoveryFlag = this.getRecoveryFlag();
        Integer other$recoveryFlag = other.getRecoveryFlag();
        if (this$recoveryFlag == null ? other$recoveryFlag != null : !((Object)this$recoveryFlag).equals(other$recoveryFlag)) {
            return false;
        }
        Integer this$invoiceStatus = this.getInvoiceStatus();
        Integer other$invoiceStatus = other.getInvoiceStatus();
        if (this$invoiceStatus == null ? other$invoiceStatus != null : !((Object)this$invoiceStatus).equals(other$invoiceStatus)) {
            return false;
        }
        String this$orderNum = this.getOrderNum();
        String other$orderNum = other.getOrderNum();
        if (this$orderNum == null ? other$orderNum != null : !this$orderNum.equals(other$orderNum)) {
            return false;
        }
        String this$vendorRecordId = this.getVendorRecordId();
        String other$vendorRecordId = other.getVendorRecordId();
        if (this$vendorRecordId == null ? other$vendorRecordId != null : !this$vendorRecordId.equals(other$vendorRecordId)) {
            return false;
        }
        String this$plateNum = this.getPlateNum();
        String other$plateNum = other.getPlateNum();
        if (this$plateNum == null ? other$plateNum != null : !this$plateNum.equals(other$plateNum)) {
            return false;
        }
        BigDecimal this$totalPrice = this.getTotalPrice();
        BigDecimal other$totalPrice = other.getTotalPrice();
        if (this$totalPrice == null ? other$totalPrice != null : !((Object)this$totalPrice).equals(other$totalPrice)) {
            return false;
        }
        BigDecimal this$paidPrice = this.getPaidPrice();
        BigDecimal other$paidPrice = other.getPaidPrice();
        if (this$paidPrice == null ? other$paidPrice != null : !((Object)this$paidPrice).equals(other$paidPrice)) {
            return false;
        }
        BigDecimal this$unpaidPrice = this.getUnpaidPrice();
        BigDecimal other$unpaidPrice = other.getUnpaidPrice();
        if (this$unpaidPrice == null ? other$unpaidPrice != null : !((Object)this$unpaidPrice).equals(other$unpaidPrice)) {
            return false;
        }
        BigDecimal this$discountPrice = this.getDiscountPrice();
        BigDecimal other$discountPrice = other.getDiscountPrice();
        if (this$discountPrice == null ? other$discountPrice != null : !((Object)this$discountPrice).equals(other$discountPrice)) {
            return false;
        }
        BigDecimal this$refundPrice = this.getRefundPrice();
        BigDecimal other$refundPrice = other.getRefundPrice();
        if (this$refundPrice == null ? other$refundPrice != null : !((Object)this$refundPrice).equals(other$refundPrice)) {
            return false;
        }
        String this$errorCauses = this.getErrorCauses();
        String other$errorCauses = other.getErrorCauses();
        if (this$errorCauses == null ? other$errorCauses != null : !this$errorCauses.equals(other$errorCauses)) {
            return false;
        }
        String this$enterDevice = this.getEnterDevice();
        String other$enterDevice = other.getEnterDevice();
        if (this$enterDevice == null ? other$enterDevice != null : !this$enterDevice.equals(other$enterDevice)) {
            return false;
        }
        String this$exitDevice = this.getExitDevice();
        String other$exitDevice = other.getExitDevice();
        if (this$exitDevice == null ? other$exitDevice != null : !this$exitDevice.equals(other$exitDevice)) {
            return false;
        }
        Date this$createTime = this.getCreateTime();
        Date other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        String this$adder = this.getAdder();
        String other$adder = other.getAdder();
        if (this$adder == null ? other$adder != null : !this$adder.equals(other$adder)) {
            return false;
        }
        Date this$updateTime = this.getUpdateTime();
        Date other$updateTime = other.getUpdateTime();
        if (this$updateTime == null ? other$updateTime != null : !((Object)this$updateTime).equals(other$updateTime)) {
            return false;
        }
        String this$updateUser = this.getUpdateUser();
        String other$updateUser = other.getUpdateUser();
        if (this$updateUser == null ? other$updateUser != null : !this$updateUser.equals(other$updateUser)) {
            return false;
        }
        String this$remark = this.getRemark();
        String other$remark = other.getRemark();
        if (this$remark == null ? other$remark != null : !this$remark.equals(other$remark)) {
            return false;
        }
        String this$parkCode = this.getParkCode();
        String other$parkCode = other.getParkCode();
        if (this$parkCode == null ? other$parkCode != null : !this$parkCode.equals(other$parkCode)) {
            return false;
        }
        String this$parkName = this.getParkName();
        String other$parkName = other.getParkName();
        if (this$parkName == null ? other$parkName != null : !this$parkName.equals(other$parkName)) {
            return false;
        }
        String this$lastPrintUser = this.getLastPrintUser();
        String other$lastPrintUser = other.getLastPrintUser();
        if (this$lastPrintUser == null ? other$lastPrintUser != null : !this$lastPrintUser.equals(other$lastPrintUser)) {
            return false;
        }
        LocalDateTime this$lastPrintTime = this.getLastPrintTime();
        LocalDateTime other$lastPrintTime = other.getLastPrintTime();
        if (this$lastPrintTime == null ? other$lastPrintTime != null : !((Object)this$lastPrintTime).equals(other$lastPrintTime)) {
            return false;
        }
        String this$berthCode = this.getBerthCode();
        String other$berthCode = other.getBerthCode();
        if (this$berthCode == null ? other$berthCode != null : !this$berthCode.equals(other$berthCode)) {
            return false;
        }
        String this$enterVideo = this.getEnterVideo();
        String other$enterVideo = other.getEnterVideo();
        if (this$enterVideo == null ? other$enterVideo != null : !this$enterVideo.equals(other$enterVideo)) {
            return false;
        }
        String this$exitVideo = this.getExitVideo();
        String other$exitVideo = other.getExitVideo();
        if (this$exitVideo == null ? other$exitVideo != null : !this$exitVideo.equals(other$exitVideo)) {
            return false;
        }
        CardTypeDto this$cardTypeDto = this.getCardTypeDto();
        CardTypeDto other$cardTypeDto = other.getCardTypeDto();
        return !(this$cardTypeDto == null ? other$cardTypeDto != null : !this$cardTypeDto.equals(other$cardTypeDto));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Order;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $parkId = this.getParkId();
        result = result * 59 + ($parkId == null ? 43 : ((Object)$parkId).hashCode());
        Integer $berthId = this.getBerthId();
        result = result * 59 + ($berthId == null ? 43 : ((Object)$berthId).hashCode());
        Integer $cardType = this.getCardType();
        result = result * 59 + ($cardType == null ? 43 : ((Object)$cardType).hashCode());
        Integer $cardTypeId = this.getCardTypeId();
        result = result * 59 + ($cardTypeId == null ? 43 : ((Object)$cardTypeId).hashCode());
        Long $enterTime = this.getEnterTime();
        result = result * 59 + ($enterTime == null ? 43 : ((Object)$enterTime).hashCode());
        Long $exitTime = this.getExitTime();
        result = result * 59 + ($exitTime == null ? 43 : ((Object)$exitTime).hashCode());
        Integer $parkDuration = this.getParkDuration();
        result = result * 59 + ($parkDuration == null ? 43 : ((Object)$parkDuration).hashCode());
        Long $reportTime = this.getReportTime();
        result = result * 59 + ($reportTime == null ? 43 : ((Object)$reportTime).hashCode());
        Integer $carType = this.getCarType();
        result = result * 59 + ($carType == null ? 43 : ((Object)$carType).hashCode());
        Integer $refundFlag = this.getRefundFlag();
        result = result * 59 + ($refundFlag == null ? 43 : ((Object)$refundFlag).hashCode());
        Integer $orderType = this.getOrderType();
        result = result * 59 + ($orderType == null ? 43 : ((Object)$orderType).hashCode());
        Integer $orderStatus = this.getOrderStatus();
        result = result * 59 + ($orderStatus == null ? 43 : ((Object)$orderStatus).hashCode());
        Integer $payStatus = this.getPayStatus();
        result = result * 59 + ($payStatus == null ? 43 : ((Object)$payStatus).hashCode());
        Integer $enterWay = this.getEnterWay();
        result = result * 59 + ($enterWay == null ? 43 : ((Object)$enterWay).hashCode());
        Integer $exitWay = this.getExitWay();
        result = result * 59 + ($exitWay == null ? 43 : ((Object)$exitWay).hashCode());
        Integer $plateColor = this.getPlateColor();
        result = result * 59 + ($plateColor == null ? 43 : ((Object)$plateColor).hashCode());
        Integer $pushEnterResult = this.getPushEnterResult();
        result = result * 59 + ($pushEnterResult == null ? 43 : ((Object)$pushEnterResult).hashCode());
        Integer $pushExitResult = this.getPushExitResult();
        result = result * 59 + ($pushExitResult == null ? 43 : ((Object)$pushExitResult).hashCode());
        Integer $recoveryFlag = this.getRecoveryFlag();
        result = result * 59 + ($recoveryFlag == null ? 43 : ((Object)$recoveryFlag).hashCode());
        Integer $invoiceStatus = this.getInvoiceStatus();
        result = result * 59 + ($invoiceStatus == null ? 43 : ((Object)$invoiceStatus).hashCode());
        String $orderNum = this.getOrderNum();
        result = result * 59 + ($orderNum == null ? 43 : $orderNum.hashCode());
        String $vendorRecordId = this.getVendorRecordId();
        result = result * 59 + ($vendorRecordId == null ? 43 : $vendorRecordId.hashCode());
        String $plateNum = this.getPlateNum();
        result = result * 59 + ($plateNum == null ? 43 : $plateNum.hashCode());
        BigDecimal $totalPrice = this.getTotalPrice();
        result = result * 59 + ($totalPrice == null ? 43 : ((Object)$totalPrice).hashCode());
        BigDecimal $paidPrice = this.getPaidPrice();
        result = result * 59 + ($paidPrice == null ? 43 : ((Object)$paidPrice).hashCode());
        BigDecimal $unpaidPrice = this.getUnpaidPrice();
        result = result * 59 + ($unpaidPrice == null ? 43 : ((Object)$unpaidPrice).hashCode());
        BigDecimal $discountPrice = this.getDiscountPrice();
        result = result * 59 + ($discountPrice == null ? 43 : ((Object)$discountPrice).hashCode());
        BigDecimal $refundPrice = this.getRefundPrice();
        result = result * 59 + ($refundPrice == null ? 43 : ((Object)$refundPrice).hashCode());
        String $errorCauses = this.getErrorCauses();
        result = result * 59 + ($errorCauses == null ? 43 : $errorCauses.hashCode());
        String $enterDevice = this.getEnterDevice();
        result = result * 59 + ($enterDevice == null ? 43 : $enterDevice.hashCode());
        String $exitDevice = this.getExitDevice();
        result = result * 59 + ($exitDevice == null ? 43 : $exitDevice.hashCode());
        Date $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        String $adder = this.getAdder();
        result = result * 59 + ($adder == null ? 43 : $adder.hashCode());
        Date $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : ((Object)$updateTime).hashCode());
        String $updateUser = this.getUpdateUser();
        result = result * 59 + ($updateUser == null ? 43 : $updateUser.hashCode());
        String $remark = this.getRemark();
        result = result * 59 + ($remark == null ? 43 : $remark.hashCode());
        String $parkCode = this.getParkCode();
        result = result * 59 + ($parkCode == null ? 43 : $parkCode.hashCode());
        String $parkName = this.getParkName();
        result = result * 59 + ($parkName == null ? 43 : $parkName.hashCode());
        String $lastPrintUser = this.getLastPrintUser();
        result = result * 59 + ($lastPrintUser == null ? 43 : $lastPrintUser.hashCode());
        LocalDateTime $lastPrintTime = this.getLastPrintTime();
        result = result * 59 + ($lastPrintTime == null ? 43 : ((Object)$lastPrintTime).hashCode());
        String $berthCode = this.getBerthCode();
        result = result * 59 + ($berthCode == null ? 43 : $berthCode.hashCode());
        String $enterVideo = this.getEnterVideo();
        result = result * 59 + ($enterVideo == null ? 43 : $enterVideo.hashCode());
        String $exitVideo = this.getExitVideo();
        result = result * 59 + ($exitVideo == null ? 43 : $exitVideo.hashCode());
        CardTypeDto $cardTypeDto = this.getCardTypeDto();
        result = result * 59 + ($cardTypeDto == null ? 43 : $cardTypeDto.hashCode());
        return result;
    }
}

