/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.city.road.domain.table;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.icetech.city.road.component.jackson.TemporalFormat;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import lombok.Generated;

@TableName(value="ice_empe_atte_plan")
public class EmpeAttePlan
implements Serializable {
    @TableId(value="id")
    protected Long id;
    @TableField(value="group_id", updateStrategy=FieldStrategy.NEVER)
    protected Long groupId;
    @TableField(value="class_id", updateStrategy=FieldStrategy.NEVER)
    protected Long classId;
    @TableField(value="park_id", updateStrategy=FieldStrategy.NEVER)
    protected Long parkId;
    @TableField(value="plan_date", updateStrategy=FieldStrategy.NEVER)
    @JsonFormat(pattern="yyyy-MM-dd")
    @TemporalFormat(pattern="yyyy-MM-dd")
    protected LocalDate planDate;
    @TableField(value="begin_date_time")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @TemporalFormat(pattern="yyyy-MM-dd HH:mm:ss")
    protected LocalDateTime beginDateTime;
    @TableField(value="end_date_time")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @TemporalFormat(pattern="yyyy-MM-dd HH:mm:ss")
    protected LocalDateTime endDateTime;
    @TableField(value="empe_id")
    protected Long empeId;
    @TableField(value="create_user", updateStrategy=FieldStrategy.NEVER)
    protected String createUser;
    @TableField(value="create_time", updateStrategy=FieldStrategy.NEVER)
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @TemporalFormat(pattern="yyyy-MM-dd HH:mm:ss")
    protected LocalDateTime createTime;
    @TableField(value="update_user")
    protected String updateUser;
    @TableField(value="update_time")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @TemporalFormat(pattern="yyyy-MM-dd HH:mm:ss")
    protected LocalDateTime updateTime;
    @TableField(exist=false)
    protected Integer atteYear;
    @TableField(exist=false)
    protected Integer atteMonth;
    @TableField(exist=false)
    protected Integer atteDay;

    public EmpeAttePlan setPlanDate(LocalDate planDate) {
        this.planDate = planDate;
        if (planDate != null) {
            this.setAtteYear(planDate.getYear());
            this.setAtteMonth(planDate.getMonthValue());
            this.setAtteDay(planDate.getDayOfMonth());
        }
        return this;
    }

    public EmpeAttePlan planDateTime(LocalDate planDate, LocalTime beginTime, LocalTime endTime) {
        this.setPlanDate(planDate);
        this.setBeginDateTime(planDate.atTime(beginTime));
        this.setEndDateTime(endTime.atDate(beginTime.isBefore(endTime) ? planDate : planDate.plusDays(1L)));
        return this;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getGroupId() {
        return this.groupId;
    }

    @Generated
    public Long getClassId() {
        return this.classId;
    }

    @Generated
    public Long getParkId() {
        return this.parkId;
    }

    @Generated
    public LocalDate getPlanDate() {
        return this.planDate;
    }

    @Generated
    public LocalDateTime getBeginDateTime() {
        return this.beginDateTime;
    }

    @Generated
    public LocalDateTime getEndDateTime() {
        return this.endDateTime;
    }

    @Generated
    public Long getEmpeId() {
        return this.empeId;
    }

    @Generated
    public String getCreateUser() {
        return this.createUser;
    }

    @Generated
    public LocalDateTime getCreateTime() {
        return this.createTime;
    }

    @Generated
    public String getUpdateUser() {
        return this.updateUser;
    }

    @Generated
    public LocalDateTime getUpdateTime() {
        return this.updateTime;
    }

    @Generated
    public Integer getAtteYear() {
        return this.atteYear;
    }

    @Generated
    public Integer getAtteMonth() {
        return this.atteMonth;
    }

    @Generated
    public Integer getAtteDay() {
        return this.atteDay;
    }

    @Generated
    public EmpeAttePlan setId(Long id) {
        this.id = id;
        return this;
    }

    @Generated
    public EmpeAttePlan setGroupId(Long groupId) {
        this.groupId = groupId;
        return this;
    }

    @Generated
    public EmpeAttePlan setClassId(Long classId) {
        this.classId = classId;
        return this;
    }

    @Generated
    public EmpeAttePlan setParkId(Long parkId) {
        this.parkId = parkId;
        return this;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Generated
    public EmpeAttePlan setBeginDateTime(LocalDateTime beginDateTime) {
        this.beginDateTime = beginDateTime;
        return this;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Generated
    public EmpeAttePlan setEndDateTime(LocalDateTime endDateTime) {
        this.endDateTime = endDateTime;
        return this;
    }

    @Generated
    public EmpeAttePlan setEmpeId(Long empeId) {
        this.empeId = empeId;
        return this;
    }

    @Generated
    public EmpeAttePlan setCreateUser(String createUser) {
        this.createUser = createUser;
        return this;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Generated
    public EmpeAttePlan setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
        return this;
    }

    @Generated
    public EmpeAttePlan setUpdateUser(String updateUser) {
        this.updateUser = updateUser;
        return this;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Generated
    public EmpeAttePlan setUpdateTime(LocalDateTime updateTime) {
        this.updateTime = updateTime;
        return this;
    }

    @Generated
    public EmpeAttePlan setAtteYear(Integer atteYear) {
        this.atteYear = atteYear;
        return this;
    }

    @Generated
    public EmpeAttePlan setAtteMonth(Integer atteMonth) {
        this.atteMonth = atteMonth;
        return this;
    }

    @Generated
    public EmpeAttePlan setAtteDay(Integer atteDay) {
        this.atteDay = atteDay;
        return this;
    }

    @Generated
    public String toString() {
        return "EmpeAttePlan(id=" + this.getId() + ", groupId=" + this.getGroupId() + ", classId=" + this.getClassId() + ", parkId=" + this.getParkId() + ", planDate=" + this.getPlanDate() + ", beginDateTime=" + this.getBeginDateTime() + ", endDateTime=" + this.getEndDateTime() + ", empeId=" + this.getEmpeId() + ", createUser=" + this.getCreateUser() + ", createTime=" + this.getCreateTime() + ", updateUser=" + this.getUpdateUser() + ", updateTime=" + this.getUpdateTime() + ", atteYear=" + this.getAtteYear() + ", atteMonth=" + this.getAtteMonth() + ", atteDay=" + this.getAtteDay() + ")";
    }

    @Generated
    public EmpeAttePlan() {
    }

    @Generated
    public EmpeAttePlan(Long id, Long groupId, Long classId, Long parkId, LocalDate planDate, LocalDateTime beginDateTime, LocalDateTime endDateTime, Long empeId, String createUser, LocalDateTime createTime, String updateUser, LocalDateTime updateTime, Integer atteYear, Integer atteMonth, Integer atteDay) {
        this.id = id;
        this.groupId = groupId;
        this.classId = classId;
        this.parkId = parkId;
        this.planDate = planDate;
        this.beginDateTime = beginDateTime;
        this.endDateTime = endDateTime;
        this.empeId = empeId;
        this.createUser = createUser;
        this.createTime = createTime;
        this.updateUser = updateUser;
        this.updateTime = updateTime;
        this.atteYear = atteYear;
        this.atteMonth = atteMonth;
        this.atteDay = atteDay;
    }
}

