package com.icetech.city.road.domain.table.carousel;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;

/**
 * @author wgq
 */
@Data
@TableName("ice_carousel_image")
public class CarouselImage {

    /**
     * ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    protected Long id;

    /**
     * 轮播图标题
     */
    private String carouTitle;

    /**
     * 公告的状态 (0 - 禁用, 1 - 启用)
     */
    private Boolean status;

    /**
     * 公告的推送状态 (0 - 未推送, 1 - 已推送)
     */
    private Boolean pushStatus;

    /**
     * 轮播图
     */
    private String carouImages;

    /**
     * 视频地址
     */
    private String carouVideo;

    /**
     * 轮播图内容
     */
    private String carouContent;

    /**
     * 公告的创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    /**
     * 公告的推送时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date pushTime;
}
