package com.icetech.city.road.domain.table;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 停车道路表
 * </p>
 *
 * @author wangzhiwei
 * @since 2021-03-04
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("ice_park")
public class Park implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键自增长id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 道路编号（唯一）
     */
    private String parkCode;

    /**
     * 道路名称
     */
    private String parkName;

    /**
     * 所属停车区id
     */
    private Integer regionId;

    /**
     * 泊位总数
     */
    private Integer totalBerthnum;
    /**
     * 空闲泊位总数
     */
    private Integer freeBerthnum;

    /**
     * 开始坐标经度
     */
    private String startLongitude;

    /**
     * 开始坐标维度
     */
    private String startDimension;

    /**
     * 中心坐标经度
     */
    private String centreLongitude;

    /**
     * 中心坐标维度
     */
    private String centreDimension;

    /**
     * 结束坐标经度
     */
    private String endLongitude;

    /**
     * 结束坐标维度
     */
    private String endDimension;

    /**
     * 计费规则编号 时间+随机数小于16位
     */
    private String billrulesCode;
    /**
     * 新能源计费规则code
     */
    private String evBillrulesCode;
    /**
     * 节假日计费规则编号
     */
    private String holidayBillrulesCode;

    /**
     * 车场对接key
     */
    private String secret;

    /**
     * 注册标识(0-未注册;1-已注册)
     */
    private Integer registerFlag;

    /**
     * 上海费率编号
     */
    protected String rateNum;

    /**
     * 添加时间
     */
    private Date createTime;

    /**
     * 添加人
     */
    private String adder;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 更新人
     */
    private String updateUser;

    /**
     * 描述信息
     */
    private String remark;


}
