package com.icetech.city.road.domain.table;

import java.math.BigDecimal;
import java.util.Date;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("ice_order_refund")
public class OrderRefund {
    /**
     * ID
     */
    @TableId("id")
    protected Long id;
    /**
     * 支付ID
     */
    @TableField("pay_id")
    protected Long payId;
    /**
     * 订单号
     */
    @TableField("order_num")
    protected String orderNum;
    /**
     * 交易号
     */
    @TableField("trade_no")
    protected String tradeNo;
    /**
     * 退款方式(1-人工;2-系统)
     */
    @TableField("refund_way")
    protected Integer refundWay;

    /**
     * 支付方式（11：微信 12：支付宝 13：银联 21：现金 22：公交卡 23：银联刷卡 31：ETC  0：其他 ）
     */
    @TableField("pay_way")
    private Integer payWay;

    /**
     * 支付来源 1：公众号 2：小程序 3：app  4：H5 6：ETC 7：POS机  99：第三方 0：其他
     */
    @TableField("pay_channel")
    private Integer payChannel;

    /**
     * 实退金额
     */
    @TableField("actual_refund_price")
    protected BigDecimal actualRefundPrice;

    /**
     * 应退金额
     */
    @TableField("refund_price")
    protected BigDecimal refundPrice;
    /**
     * 退款时间
     */
    @TableField("refund_time")
    protected Date refundTime;
    /**
     * 创建时间
     */
    @TableField("create_time")
    protected Date createTime;

    /**
     * -1=已取消 0= 待审核 1=未退款 2=退款中 3=退款成功 4=退款失败
     */
    @TableField("refund_res")
    protected Integer refundRes;

    /**
     * 退款失败原因
     */
    @TableField("refund_fail_msg")
    protected String refundFailMsg;


    /**
     * 退款原因
     */
    @TableField("reason")
    protected String reason;
}
