package com.icetech.city.road.domain.table;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;

import java.io.Serializable;
import java.util.Date;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 优惠记录表
 * </p>
 *
 * @author wangzhiwei
 * @since 2021-03-17
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("ice_order_discount")
public class OrderDiscount implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 自增主键id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 车场id
     */
    private Integer parkId;

    /**
     * 订单号
     */
    private String orderNum;

    /**
     * 交易流水号
     */
    private String tradeNo;

    /**
     * 优惠券名称
     */
    private String discountName;

    /**
     * 优惠券来源
     */
    private String source;

    /**
     * 优惠券编号
     */
    private String discountNo;

    /**
     * 车牌号
     */
    private String plateNum;

    /**
     * 优惠券类型（1：全免，2：减免时间，3：减免金额，4：折扣）
     */
    private Integer type;

    /**
     * 优惠券面值
     */
    private String amount;

    /**
     * 操作人
     */
    private String operAccount;

    /**
     * 状态（0：未使用，1：已使用，默认0）
     */
    private Boolean status;

    /**
     * 实际优惠金额
     */
    private BigDecimal getAmount;

    /**
     * 发放时间
     */
    private Long sendTime;

    /**
     * 使用时间
     */
    private Long useTime;

    /**
     * 添加时间
     */
    private Date createTime;

    /**
     * 更新时间
     */
    private Date updateTime;


}
