package com.icetech.city.road.domain.table;

import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;

import java.io.Serializable;
import java.util.Date;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 停车泊位表
 * </p>
 *
 * @author wangzhiwei
 * @since 2021-03-04
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("ice_berth")
public class Berth implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键自增长id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 泊位编号（唯一）
     */
    private String berthCode;


    /**
     * 所属道路id
     */
    private Integer parkId;

    /**
     * 泊位状态1：无车，2：有车未下单，3：有车已下单，默认1
     */
    private Integer berthStatus;

    /**
     * 运行状态（1：正常，2：禁用，默认1）
     */
    private Integer berthUsing;

    /**
     * 泊位模式（1：收费，2：不收费，默认1）
     */
    private Integer berthMode;

    /**
     * 设备类型（1：高位视频，2：地磁）
     */
    private Integer berthDevice;

    /**
     * 所属设备id
     */
    private Integer berthDev;

    /**
     * 计费规则编号 时间+随机数小于16位
     */
    private String billrulesCode;

    /**
     * 中心坐标经度
     */
    private String centreLongitude;

    /**
     * 中心坐标维度
     */
    private String centreDimension;

    /**
     * 注册标识(0-未注册;1-已注册)
     */
    private Integer registerFlag;

    /**
     * 添加时间
     */
    private Date createTime;

    /**
     * 添加人
     */
    private String adder;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 更新人
     */
    private String updateUser;

    /**
     * 描述信息
     */
    private String remark;
    /**
     *
     */
    private Boolean isDelete;


}
