package com.icetech.city.road.domain.table;

import com.baomidou.mybatisplus.annotation.TableName;

import java.io.Serializable;
import java.util.Date;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 审核记录表
 * </p>
 *
 * @author wangzhiwei
 * @since 2021-05-07
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("ice_approve_record")
public class ApproveRecord implements Serializable {

    private static final long serialVersionUID = 1L;

    private Integer id;

    /**
     * 道路id
     */
    private Integer parkId;

    /**
     * 第三方记录号
     */
    private String recordId;

    /**
     * 泊位id
     */
    private Integer berthId;

    /**
     * 设备sn号
     */
    private String deviceSn;

    /**
     * 车位状态1=无车 2=有车
     */
    private Integer spaceStatus;

    /**
     * 泊位置信度
     */
    private String spaceCas;

    /**
     * 车牌号
     */
    private String plateNum;

    /**
     * 车牌置信度
     */
    private String plateCas;

    /**
     * 车牌颜色
     */
    private Integer plateColor;

    /**
     * 车牌类型
     */
    private Integer plateType;
    /**
     * 入场或出场+停车行为异常标识枚举
     */
    private Integer warningReason;

    /**
     * 审核状态1=待审核 2=审核拒绝 3=审核通过
     */
    private Integer approveStatus;

    /**
     * 待审核原因
     */
    private Integer waitApproveReason;

    /**
     * 审核结果
     */
    private Integer approveResult;

    /**
     * 审核人
     */
    private String approver;

    /**
     * 审核时间
     */
    private Long approveTime;

    /**
     * 上报时间
     */
    private Long reportTime;

    private Date createTime;

    private String adder;

    private Date updateTime;

    private String updateUser;

    private String remark;


}
