package com.icetech.city.road.domain.table;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.icetech.city.road.component.jackson.TemporalFormat;
import com.icetech.city.road.utils.DateUtils;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 安卓app管理
 * </p>
 *
 * @author wangzhiwei
 * @since 2021-04-02
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("ice_apk_version")
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class ApkVersion implements Serializable {

    private static final long serialVersionUID = 1L;

    private Integer id;

    /**
     * apk名称
     */
    private String apkName;

    /**
     * apk版本
     */
    private String apkVersion;
    /** 版本号 */
    private Integer versionNum;

    /**
     * apk存储地址
     */
    private String apkPath;

    /**
     * 备注
     */
    private String remark;
    /**
     * 返回list的
     */
    @TableField(exist=false)
    private List<String> remarks;

    /**
     * 是否可用1=可以0=不可以
     */
    private Boolean active;
    /** 启用时间 */
    @JsonFormat(pattern = DateUtils.DEFAULT_DATETIME_PATTERN)
    @TemporalFormat(pattern = DateUtils.DEFAULT_DATETIME_PATTERN)
    private LocalDateTime activeTime;
    /**
     * 是否强制更新
     */
    private Boolean forceUpdate;

    @JsonFormat(pattern = DateUtils.DEFAULT_DATETIME_PATTERN)
    @TemporalFormat(pattern = DateUtils.DEFAULT_DATETIME_PATTERN)
    private Date createTime;

    public static final Integer ACTIVE_YES = 1;
    public static final Integer ACTIVE_NO = 0;
}
