package com.icetech.city.road.domain.entity.dto;

import java.math.BigDecimal;
import java.util.List;

import com.icetech.city.road.domain.table.Park;
import com.icetech.city.road.domain.table.PosOrderRegAggr;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString(callSuper = true)
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
public class PosOrderRegAggrDto extends PosOrderRegAggr {
    protected String empeUsername;
    protected String empeName;
    protected String parkName;

    /** 登记率百分比 */
    protected BigDecimal regRatePer;
    /** 登记及时率百分比 */
    protected BigDecimal regTimelyRatePer;
    /** 登记率百分比(强制两位效率) */
    protected String regRatePerStr;
    /** 登记及时率百分比(强制两位效率) */
    protected String regTimelyRatePerStr;

    protected String aggrYearMonth;
    protected String parkGroup;
    protected List<Park> parks;
}
