package com.icetech.city.road.component.bean;

import com.github.pagehelper.PageInfo;
import com.icetech.city.road.component.constant.CodeConstants;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 表格分页数据对象
 *
 * @author ice
 */

@Data
public class TableDataInfo<T> implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 总记录数
     */
    private long total;

    /**
     * 列表数据
     */
    private T data;

    /**
     * 消息状态码
     */
    private String code;

    /**
     * 消息内容
     */
    private String msg;


    /**
     * 表格数据对象
     */
    public TableDataInfo() {
    }

    /**
     * 分页
     *
     * @param list  列表数据
     * @param total 总记录数
     */
    public TableDataInfo(T list, long total) {
        this.data = list;
        this.total = total;
    }

}
