package com.icetech.city.road.app.undefined.dto;

import com.icetech.city.road.domain.constant.PayChannelConstant;
import com.icetech.city.road.domain.constant.PayWayConstant;
import com.icetech.city.road.domain.entity.request.param.MonthCardPaymentReq;
import com.icetech.city.road.domain.table.MonthInfo;
import lombok.Data;

@Data
public class MonthPayToRes extends BasePrePayRes {
    /**
     * 支付来源（1：H5）
     */
    private Integer payChannel = PayChannelConstant.WECHAT_MINI;

    /**
     * 支付方式（1：微信，2：支付宝）非必填
     */
    private Integer payWay = PayWayConstant.WECHAT;

    /**
     * 第三方交易流水号
     */
    private String outTradeNo;

    /**
     * 请求流水号
     */
    private String tradeNo;

    /**
     * 支付渠道1：微信直连，2：支付宝直连，3：兴业银行，4:农发行
     */
    private Integer payAisle;

    /**
     * 支付时间
     */
    private Long payTime;

    /**
     * 月卡开办信息
     */
    private MonthInfo monthInfo;

    /**
     * 请求开卡信息
     */
    private MonthCardPaymentReq monthCardPaymentReq;
}
