package com.icetech.city.road.utils;

import java.util.LinkedHashSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class StringUtils extends org.apache.commons.lang3.StringUtils {
    public static String parseString(Object object) {
        if (object == null) return "";
        return object.toString();
    }

    public static String ifBlank(String content, String replace) {
        return isBlank(content) ? replace : content;
    }

    public static String[] trimDistinctSplit(String content, String regex) {
        if (content == null) return new String[0];

        String[] array = content.split(regex);
        return Stream.of(array).map(StringUtils::trim).filter(StringUtils::isNotBlank).distinct().toArray(String[]::new);
    }

    public static LinkedHashSet<String> trimSetSplit(String content, String regex) {
        if (content == null) return new LinkedHashSet<>();

        String[] array = content.split(regex);
        return filterNotBlank(Stream.of(array));
    }

    public static LinkedHashSet<String> filterNotBlank(Stream<String> stream) {
        return stream.map(StringUtils::trim).filter(StringUtils::isNotBlank).collect(Collectors.toCollection(LinkedHashSet::new));
    }
}
