package com.icetech.city.road.domain.table.announ;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;

/**
 * 资讯公告
 *
 * @author wgq
 */
@Data
@TableName("ice_announcement")
public class Announcement {
    /**
     * ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    protected Long id;
    /**
     * 公告标题
     */
    private String noticeTitle;
    /**
     * 公告的状态 (0 - 禁用, 1 - 启用)
     */
    private Boolean status;
    /**
     * 公告的推送状态 (0 - 未推送, 1 - 已推送)
     */
    private Boolean pushStatus;
    /**
     * 公告封面
     */
    private String noticeCover;
    /**
     * 公告视频
     */
    private String noticeVideo;
    /**
     * 公告简介
     */
    private String noticeAbstract;
    /**
     * 公告详情
     */
    private String noticeDetail;
    /**
     * 公告的创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;
    /**
     * 公告的推送时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date pushTime;
}
