package com.icetech.city.road.domain.table;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * 模版参数表
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("ice_template_param")
public class TemplateParam {
    /**
     * ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 参数名称（中文）
     */
    @TableField("cn_name")
    private String cnName;

    /**
     * 参数名称（英文）
     */
    @TableField("en_name")
    private String enName;

    /**
     * 参数位置（0-居左；1-居中；2-居右）
     */
    @TableField("position")
    private Integer position;

    /**
     * 字体大小(0-小；1-中；2-大)
     */
    @TableField("font")
    private Integer font;

    /**
     * 是否加粗（0-否；1-是）
     */
    @TableField("is_bolded")
    private Integer isBolded;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private Date createTime;
}
