package com.icetech.city.road.domain.table;

import java.util.Date;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * SIM卡信息表
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("ice_sim_card")
public class SimCard {
    /**
     * ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    protected Long id;
    /**
     * 道路ID
     */
    protected Long parkId;
    /**
     * SIM卡别名
     */
    protected String simName;
    /**
     * SIM卡编号
     */
    protected String simCode;
    /**
     * 手机号
     */
    protected String phoneNum;
    /**
     * 运营商(1-移动;2-联通;3-电信;4-虚拟;9-其它)
     */
    protected Integer operator;
    /**
     * 注册标识(0-未注册;1-已注册)
     */
    protected Integer registerFlag;
    /**
     * 注册泊位绑定标识(0-未注册;1-已注册)
     */
    protected Integer registerBerthBindFlag;
    /**
     * 创建者
     */
    protected String createUser;
    /**
     * 创建时间
     */
    protected Date createTime;
    /**
     * 修改者
     */
    protected String updateUser;
    /**
     * 修改时间
     */
    protected Date updateTime;
}
