package com.icetech.city.road.domain.table;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;

/**
 * 凭条模板
 *
 * @author wgq
 */
@Data
@TableName("ice_receipt_template")
public class ReceiptTemplate {

    /**
     * 自增主健id
     */
    @TableId(value = "id", type = IdType.AUTO)
    protected Integer id;

    /**
     * 元素ID
     */
    private String elementId;
    /**
     * 模板ID
     */
    private Integer templateId;

    /**
     * 类型 1- 文本 2- 二维码 3-空行
     */
    private Integer type;
    /**
     * 字体大小 1-小 3-中 5-大
     */
    private Integer fontSize;
    /**
     * 字体粗细 1-粗 2-细
     */
    private Integer fontWeight;
    /**
     * 位置 1-左 3-中 5-右
     */
    private Integer align;
    /**
     * 字段名称-英文
     */
    private String columnEn;
    /**
     * 字段名称-中文
     */
    private String columnName;
    /**
     * 内容
     */
    private String content;
    /**
     * 展示内容不展示字段名称 0 -否 1-是
     */
    private Boolean dcwofn;
    /**
     * 展示字段名称替换内容 0 -否 1-是
     */
    private Boolean dfnrc;
    /**
     * 展示字段名称展示内容 0 -否 1-是
     */
    private Boolean dfndc;
    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;
}
