package com.icetech.city.road.domain.table;

import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

/**
 * <p>
 * 用户与道路关联表
 * </p>
 *
 * @author wangzhiwei
 * @since 2021-03-05
 */
@Getter
@Setter
@ToString
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
@TableName("ice_pos_user_park")
public class PosUserPark implements Serializable {
    private static final long serialVersionUID = 1L;
    /** id */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;
    /** 用户id */
    private Integer userId;
    /** 车场id */
    private Integer parkId;
}
