package com.icetech.city.road.domain.table;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Set;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.icetech.city.road.domain.entity.request.param.PosLoginRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * POS机用户表
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("ice_pos_user")
public class PosUser implements Serializable {
    private static final long serialVersionUID = 1L;
    /**
     * ID (主健自增)
     */
    @TableId("id")
    protected Integer id;
    /**
     * 用户名
     */
    @TableField("username")
    protected String username;
    /**
     * 密码
     */
    @TableField("password")
    protected String password;
    /**
     * 员工编号
     */
    @TableField("user_num")
    protected String userNum;
    /**
     * 真实姓名
     */
    @TableField("name")
    protected String name;
    /**
     * 证件号码
     */
    @TableField("id_card_num")
    protected String idCardNum;
    /**
     * 联系方式
     */
    @TableField("phone")
    protected String phone;
    /**
     * Email
     */
    @TableField("email")
    protected String email;
    /**
     * 地址
     */
    @TableField("address")
    protected String address;
    /**
     * 最后登录时间
     */
    @TableField("last_login")
    protected LocalDateTime lastLogin;
    /**
     * 最后登录ip
     */
    @TableField("last_ip")
    protected String lastIp;
    /**
     * 状态（0正常、1冻结
     */
    @TableField("status")
    protected Integer status;
    /**
     * 注册标识(0-未注册;1-已注册)
     */
    @TableField("register_flag")
    protected Integer registerFlag;
    /**
     * 是否删除（0正常、1删除）
     */
    @TableField("is_delete")
    protected Boolean isDelete;
    /**
     * 添加人
     */
    @TableField("create_user")
    protected String createUser;
    /**
     * 添加时间
     */
    @TableField("create_time")
    protected LocalDateTime createTime;


    @TableField(exist = false)
    protected PosLoginRequest loginInfo;
    @TableField(exist = false)
    protected Set<Integer> roadIds;
    @TableField(exist = false)
    protected String loginToken;
    @TableField(exist = false)
    protected String loginPosSn;
}
