package com.icetech.city.road.domain.table;

import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * Pos机心跳上报记录
 * </p>
 *
 * @author wangzhiwei
 * @since 2021-08-31
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("ice_pos_heartbeat_record")
public class PosHeartbeatRecord implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 用户id
     */
    private Integer userId;

    /**
     * 坐标格式  经度,纬度
     */
    private String location;

    /**
     * 坐标转换的地址信息
     */
    private String address;

    /**
     * 上报时间
     */
    private Long reportTime;

    private LocalDateTime createTime;

    private String adder;


}
