package com.icetech.city.road.domain.table;

import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 订单车辆详情信息表
 * </p>
 *
 * @author wangzhiwei
 * @since 2021-05-11
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("ice_picture_record")
public class PictureRecord implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键自增长id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 记录id
     */
    private String recordId;

    /**
     * 业务类型（1：事件图片，2：特写图片）
     */
    private Integer enexType;

    /**
     * 图片路径
     */
    private String imageUrl;

    /**
     * 上报时间
     */
    private Long reportTime;


}
