package com.icetech.city.road.domain.table;

import java.io.Serializable;
import java.util.Date;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 参数配置
 */
@Data
@Accessors(chain = true)
@TableName("ice_param_config")
public class ParamConfig implements Serializable {
    /**
     * ID
     */
    @TableId(value = "`id`", type = IdType.AUTO)
    protected Long id;
    /**
     * 参数名
     */
    @TableField("`param_name`")
    protected String paramName;
    /**
     * 参数值
     */
    @TableField("`param_value`")
    protected String paramValue;
    /**
     * 参数说明
     */
    @TableField("`param_desc`")
    protected String paramDesc;
    /**
     * 注册标识(0-未注册;1-已注册)
     */
    @TableField("`register_flag`")
    protected Integer registerFlag;

    @TableField("`create_user`")
    protected String createUser;
    @TableField("`create_time`")
    protected Date createTime;
    @TableField("`update_user`")
    protected String updateUser;
    @TableField("`update_time`")
    protected Date updateTime;
}
