package com.icetech.city.road.domain.table;

import java.io.Serializable;
import java.util.Date;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.experimental.Accessors;

@Data
@Accessors(chain = true)
@TableName("ice_mp_user")
public class MpUser implements Serializable {
    /**
     * ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    protected Long id;
    /** OpenID */
    @TableField("union_id")
    protected String unionId;
    /** OpenID */
    @TableField("open_id")
    protected String openId;
    /**
     * 头像地址
     */
    @TableField("head_url")
    protected String headUrl;
    /**
     * 昵称
     */
    @TableField("nickname")
    protected String nickname;
    /**
     * 手机号
     */
    @TableField("phone")
    protected String phone;
    /**
     * 状态(0-正常)
     */
    @TableField("`status`")
    protected String status;
    /**
     * 创建时间
     */
    @TableField("create_time")
    protected Date createTime;
    /**
     * 修改时间
     */
    @TableField("update_time")
    protected Date updateTime;
}
