package com.icetech.city.road.domain.table;

import java.io.Serializable;
import java.time.LocalDateTime;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.icetech.city.road.component.jackson.TemporalFormat;
import com.icetech.city.road.utils.DateUtils;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
@TableName("ice_empe_atte_group")
public class EmpeAtteGroup implements Serializable {
    /** ID */
    @TableId("id")
    protected Long id;
    /** 分组名称 */
    @TableField("group_name")
    protected String groupName;
    /** 考勤岗位(1-POS机) */
    @TableField("atte_post")
    protected Integer attePost;
    /** 分组备注 */
    @TableField("group_remark")
    protected String groupRemark;
    /** 创建人 */
    @TableField("create_user")
    protected String createUser;
    /** 创建时间 */
    @TableField("create_time")
    @JsonFormat(pattern = DateUtils.DEFAULT_DATETIME_PATTERN)
    @TemporalFormat(pattern = DateUtils.DEFAULT_DATETIME_PATTERN)
    protected LocalDateTime createTime;
    /** 修改人 */
    @TableField("update_user")
    protected String updateUser;
    /** 修改时间 */
    @TableField("update_time")
    @JsonFormat(pattern = DateUtils.DEFAULT_DATETIME_PATTERN)
    @TemporalFormat(pattern = DateUtils.DEFAULT_DATETIME_PATTERN)
    protected LocalDateTime updateTime;
}
