package com.icetech.city.road.domain.table;

import java.io.Serializable;
import java.math.BigDecimal;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
@TableName("ice_charge_dyration")
public class ChargeDuration implements Serializable {
    /** id */
    @TableId(type = IdType.AUTO)
    protected Integer id;
    /** 计费规则编号 时间+随机数小于16位 */
    protected String billtypecode;
    /** 收费类型 1：通用自然天收费 2：白天夜间收费 */
    protected Integer isnaturaldayfee;
    /** {@link #isnaturaldayfee}是1时：是工作日或非工作日计费标识 1：工作日 2非工作日；
     * {@link #isnaturaldayfee}是2时：是白天或夜间计费标识 1：白天 2夜间 */
    protected Integer dayornightfeemark;
    /** 计时开始时间 分钟 */
    protected Integer startTimeModule;
    /** 计时结束时间 分钟 */
    protected Integer endTimeModule;
    /** 超出多少分钟配置是否起作用 1：是 2否 默认为2 */
    protected Integer isOverTimeSet;
    /** 超过分钟数  分钟 */
    protected Integer overTime;
    /** 单位时间  分钟 */
    protected Integer feespantime;
    /** 单位金额 元 */
    protected BigDecimal feespanrate;
    /** 大型车单位金额 元 */
    protected BigDecimal feespanrateBig;
}
