package com.icetech.city.road.domain.entity.request.param;

import lombok.Data;

import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@Data
public class MonthCardPaymentReq implements Serializable {
    /**
     * 微信ID
     */
    private String openId;

    /**
     * 月卡ID
     */
    @NotNull(message = "月卡套餐ID不能为空")
    private Integer productId;

    /**
     * 金额
     */
    @NotNull(message = "金额不能为空")
    private BigDecimal amount;

    /**
     * 车牌号
     */
    @NotEmpty(message = "车牌号不能为空")
    private String plateNum;

    /**
     * 月卡开始时间
     */
    @NotNull(message = "月卡开始时间不能为空")
    private Date startDate;

    /**
     * 月卡结束时间
     */
    @NotNull(message = "月卡结束时间不能为空")
    private Date endDate;

    /**
     * 产品面额
     */
    @NotNull(message = "产品面额不能为空")
    private Integer duration;

    /**
     * 操作类型1 新增 2 续费 3 修改 4 退卡
     */
    private int cardOpertype = 1;
}
