package com.icetech.city.road.utils;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;

import cn.hutool.core.lang.Snowflake;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.MDC;

public class Slf4jUtils {
    public static final String KEY_TRACE_ID = "TraceId";
    private static final Snowflake SNOWFLAKE;

    static {
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        String name = runtime.getName(); // format: "pid@hostname"
        int pid = NumberUtils.toInt(StringUtils.substring(name, 0, name.indexOf("@")));
        SNOWFLAKE = new Snowflake(pid % 31, 0);
    }

    public static String putTraceId() {
        return putTraceId(SNOWFLAKE.nextIdStr());
    }

    public static String putTraceId(String traceId) {
        MDC.put(KEY_TRACE_ID, traceId);
        return traceId;
    }

    public static String initTraceId(String traceId) {
        if (StringUtils.isBlank(traceId))
            return putTraceId();
        return putTraceId(traceId);
    }

    public static String putTraceIdIfAbsent() {
        String traceId = getTraceId();
        if (StringUtils.isBlank(traceId)) {
            return putTraceId();
        }
        return traceId;
    }

    public static String getTraceId() {
        return MDC.get(KEY_TRACE_ID);
    }

    public static void removeTraceId() {
        MDC.remove(KEY_TRACE_ID);
    }
}
