package com.icetech.city.road.domain.table;

import java.util.Date;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 跨协管单位补缴
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("`znjt_crosspay`")
public class ZnjtCrossPay {
    /**
     * 自增主键ID
     */
    @TableId(value = "`id`")
    protected Long id;
    /**
     * 业务编号(订单号)
     */
    @TableField(value = "`business_id`")
    protected String businessId;
    /**
     * 欠费订单号(支付流水号)
     */
    @TableField(value = "`owe_order_id`")
    protected String oweOrderId;
    /**
     * 车牌号码
     */
    @TableField(value = "`plate_id`")
    protected String plateId;
    /**
     * 车牌颜色
     */
    @TableField(value = "`plate_color`")
    protected Integer plateColor;
    /**
     * 停车道路编号
     */
    @TableField(value = "`road_id`")
    protected String roadId;
    /**
     * 停车道路名称
     */
    @TableField(value = "`road_name`")
    protected String roadName;
    /**
     * 停车的泊位
     */
    @TableField(value = "`berth_id`")
    protected String berthId;
    /**
     * 停车路段所属的协管单位
     */
    @TableField(value = "`company_id`")
    protected String companyId;
    /**
     * 进场时间(Unix时间戳, 毫秒)
     */
    @TableField(value = "`arrive_time`")
    protected Long arriveTime;
    /**
     * 离场时间(Unix时间戳, 毫秒)
     */
    @TableField(value = "`left_time`")
    protected Long leftTime;
    /**
     * 停放时长(单位: 秒)
     */
    @TableField(value = "`parking_time`")
    protected Integer parkingTime;
    /**
     * 离场类型
     * 2-收费员不在场欠费驶离
     * 3-当面拒缴驶离
     * 4-欠费关单
     * 5-线上支付
     */
    @TableField(value = "`left_type`")
    protected Integer leftType;
    /**
     * 停车道路所在区
     */
    @TableField(value = "`district_id`")
    protected String districtId;
    /**
     * 补缴收费协管员
     */
    @TableField(value = "`pay_user_id`")
    protected String payUserId;
    /**
     * 补缴收费协管单位
     */
    @TableField(value = "`pay_company_id`")
    protected String payCompanyId;
    /**
     * 支付类型
     * 10-电子支付
     * 11-电子支付微信
     * 12-电子支付支付宝
     * 13-电子支付银联闪付
     */
    @TableField(value = "`pay_type`")
    protected Integer payType;
    /**
     * 补缴金额(单位: 分)
     */
    @TableField(value = "`pay_money`")
    protected Integer payMoney;
    /**
     * 补缴收费订单号(支付流水号)
     */
    @TableField(value = "`pay_order_id`")
    protected String payOrderId;
    /**
     * 补缴收费所在区
     */
    @TableField(value = "`pay_district_id`")
    protected String payDistrictId;
    /**
     * 补缴支付时间(Unix时间戳, 毫秒)
     */
    @TableField(value = "`pay_time`")
    protected Long payTime;
    /**
     * 电子票据号
     */
    @TableField(value = "`bill_id`")
    protected String billId;
    /**
     * 创建时间
     */
    @TableField(value = "`create_time`")
    protected Date createTime;
}
