package com.icetech.city.road.domain.table;

import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import java.util.Date;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * VIP车辆类型表
 * </p>
 *
 * @author wangzhiwei
 * @since 2021-08-31
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("ice_vip_type")
public class VipType implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 车辆类型名称
     */
    private String name;

    /**
     * 车场id
     */
    private Integer parkId;

    /**
     * 计费id （ice_park_chargeconfig表中自增id）
     */
    private Integer billId;

    /**
     * 优惠类型0不优惠 1：全免2:减免时间 3:减免金额 4：折扣减免
     */
    private Integer type;

    /**
     * 优惠数额内容：减免时长（分钟）/减免金额（元）/时长全免/折扣金额（5.5折，此字段就写5.5，这里是大于0小于10的数）
     */
    private String amount;

    /**
     * 操作人
     */
    private String operAccount;

    private String remark;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新人
     */
    private String updateUser;

    /**
     * 更新时间
     */
    private Date updateTime;


}
