package com.icetech.city.road.domain.table;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Date;

/**
 * <p>
 * VIP车辆操作记录表
 * </p>
 *
 * @author wangzhiwei
 * @since 2021-08-31
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("ice_vip_record")
public class VipRecord implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 车场ID
     */
    private Integer parkId;

    /**
     * VIP信息表id
     */
    private Integer vipId;

    /**
     * VIP类型id
     */
    private Integer typeId;

    /**
     * 车牌号，多个车牌之间用逗号隔开
     */
    private String plateNum;

    /**
     * 操作类型，1：添加，2：编辑，3：删除
     */
    private Integer operType;

    /**
     * 姓名
     */
    private String owner;

    /**
     * 电话
     */
    private String phone;

    /**
     * 有效开始日期
     */
    private Date startTime;

    /**
     * 有效结束日期
     */
    private Date endTime;

    /**
     * 备注
     */
    private String remark;

    /**
     * 办理人
     */
    private String operAccount;

    /**
     * 操作时间
     */
    private LocalDateTime operTime;


}
