package com.icetech.city.road.domain.table;

import java.io.Serializable;
import java.time.LocalDateTime;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.icetech.city.road.component.jackson.TemporalFormat;
import com.icetech.city.road.utils.DateUtils;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@Accessors(chain = true)
@NoArgsConstructor
@AllArgsConstructor
@TableName("ice_spec_car_type")
public class SpecCarType implements Serializable {
    private static final long serialVersionUID = 1L;
    /** ID */
    @TableId(type = IdType.AUTO)
    protected Integer id;
    /** 类型名称 */
    protected String typeName;
    /**
     * 优惠类型(0-无;1-全免;2-减免时长;3-减免金额;4-折扣)
     * @see com.icetech.city.road.domain.constant.DiscountTypeConstant
     */
    protected Integer discType;
    /** 优惠值 */
    protected String discValue;
    /** 启用标识(0/1) */
    protected Integer enableFlag;
    /** 创建人 */
    @TableField(value = "create_user", updateStrategy = FieldStrategy.NEVER)
    protected String createUser;
    /** 创建时间 */
    @TemporalFormat(pattern = DateUtils.DEFAULT_DATETIME_PATTERN)
    @TableField(value = "create_time", updateStrategy = FieldStrategy.NEVER)
    protected LocalDateTime createTime;
    /** 修改人 */
    protected String updateUser;
    /** 修改时间 */
    @TemporalFormat(pattern = DateUtils.DEFAULT_DATETIME_PATTERN)
    protected LocalDateTime updateTime;
}
