package com.icetech.city.road.domain.table;

import java.util.Date;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 服务器硬件资源告警表
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("ice_server_hardware_alarm")
public class ServerHardwareAlarm {
    /**
     * ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    protected Long id;
    /**
     * 服务器host
     */
    protected String serverHost;
    /**
     * 服务器IP
     */
    protected String serverIp;
    /**
     * 告警类型(1-CPU;2-内存;3-硬盘;)
     */
    protected Integer alarmType;
    /**
     * 告警原因
     */
    protected String alarmReason;
    /**
     * 发生时间
     */
    protected Date alarmTime;
    /**
     * 恢复时间
     */
    protected Date resumeTime;
    /**
     * 告警描述
     */
    protected String alarmDesc;
    /**
     * 创建时间
     */
    protected Date createTime;
}
