package com.icetech.city.road.domain.table;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 停车场商户信息表
 * </p>
 *
 * @author wangzhiwei
 * @since 2021-04-22
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("ice_park_merchant")
public class ParkMerchant implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 停车场id
     */
    private Integer parkId;

    /**
     * 商户号
     */
    private String code;

    /**
     * 商户名称
     */
    private String name;

    /**
     * 负责人手机号
     */
    private String phone;

    /**
     * 是否可透支余额,0：否，1：是
     */
    private Boolean overdrawFlag;

    /**
     * 可透支金额
     */
    private BigDecimal overdrawAmount;

    /**
     * 可用余额
     */
    private BigDecimal balance;

    /**
     * 系统自动添加 0不支持，1支持
     */
    private Integer isQrcode;

    /**
     * 优免车位个数
     */
    private Integer spaceNum;

    /**
     * 状态，0：正常，1：删除
     */
    private Boolean status;

    /**
     * 添加人
     */
    private String adder;

    /**
     * 修改人
     */
    private String editer;

    private LocalDateTime createTime;

    private LocalDateTime updateTime;


}
