package com.icetech.city.road.domain.table;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 支付明细表
 * </p>
 *
 * @author wangzhiwei
 * @since 2021-03-04
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("ice_order_pay")
public class OrderPay implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键自增长id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 道路id
     */
    private Integer parkId;

    /**
     * 订单号
     */
    private String orderNum;

    /**
     * 交易流水号(系统内部交易流水号)
     */
    private String tradeNo;
    /**
     * 第三方交易流水号
     */
    private String outTradeNo;

    /**
     * 车牌号
     */
    private String plateNum;

    /**
     * 泊位id
     */
    private Integer berthId;

    /**
     * 车辆类型(1:临时车，默认1)
     */
    private Integer cardType;

    /**
     * 进场时间
     */
    private Long enterTime;

    /**
     * 当钱缴费的停车时长
     */
    private Integer timeSlot;

    /**
     * 应收金额
     */
    private BigDecimal totalPrice;

    /**
     * 实收金额
     */
    private BigDecimal paidPrice;

    /**
     * 优惠金额
     */
    private BigDecimal discountPrice;

    /**
     * 退款金额
     */
    private BigDecimal refundPrice;

    /**
     * 支付状态(-2:支付失败;-1:已取消;0:待支付;1:支付完成;2:已退款)
     */
    private Integer payStatus;

    /**
     * 支付方式 11：微信 12：支付宝 13：银联 21：现金 22：公交卡 23：银联刷卡 31：ETC  0：其他
     */
    private Integer payWay;

    /**
     * 支付来源 1：公众号 2：小程序 3：app  4：H5 6：ETC 7：POS机  99：第三方 0：其他
     */
    private Integer payChannel;

    /**
     * 支付渠道 1：微信直连，2：支付宝直连，3：兴业银行 4：农发行
     */
    private Integer payAisle;

    /**
     * 支付类型(1:预缴费;2:补缴)
     */
    private Integer payType;

    /**
     * 下单时间
     */
    private Long orderTime;

    /**
     * 支付时间
     */
    private Long payTime;

    /**
     * 上次交费时间
     */
    private Long lastPayTime;

    /**
     * 是否开发票
     */
    private Boolean invoice;
    /**
     * 车牌颜色
     */
    private Integer plateColor;

    /**
     * 退款金额
     */
    private Long refundId;

    /**
     * 发票编码
     */
    private String billCode;

    /**
     * 添加时间
     */
    private Date createTime;

    /**
     * 添加人
     */
    private String adder;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 更新人
     */
    private String updateUser;

    /**
     * 描述信息
     */
    private String remark;


    /**
     * 车场编号
     */
    @TableField(exist = false)
    private String parkCode;
    /**
     * 车场名称
     */
    @TableField(exist = false)
    private String parkName;
    /**
     * 泊位编号
     */
    @TableField(exist = false)
    private String berthCode;

    /**
     * 员工ID
     */
    private String employeeId;

    /**
     * 银行商户单号
     */
    private String bankId;
}
