package com.icetech.city.road.domain.table;

import java.io.Serializable;
import java.util.Date;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 车牌抬头
 */
@Data
@Accessors(chain = true)
@TableName("ice_mp_user_invoice_title")
public class MpUserInvoiceTitle implements Serializable {
    /** ID */
    @TableId(value = "id", type = IdType.AUTO)
    protected Long id;
    /** 微信用户ID */
    @TableField("user_id")
    protected Long userId;
    /** 抬头类型(1-个人；2-企业) */
    @TableField("title_type")
    protected Integer titleType;
    /** 发票抬头 */
    @TableField("invoice_title")
    protected String invoiceTitle;
    /** 纳税人识别号 */
    @TableField("taxpayer_num")
    protected String taxpayerNum;
    /** 单位地址 */
    @TableField("company_addr")
    protected String companyAddr;
    /** 电话号码 */
    @TableField("phone_num")
    protected String phoneNum;
    /** 开户银行 */
    @TableField("accounts_bank")
    protected String accountsBank;
    /** 银行账号 */
    @TableField("bank_account")
    protected String bankAccount;
    /** 电子邮箱 */
    @TableField("email")
    protected String email;
    /** 创建时间 */
    @TableField("create_time")
    protected Date createTime;
    /** 修改时间 */
    @TableField("update_time")
    protected Date updateTime;
}
