package com.icetech.city.road.domain.table;

import java.io.Serializable;
import java.util.Date;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.experimental.Accessors;

@Data
@TableName("ice_mp_user_advice_reply")
@Accessors(chain = true)
public class MpUserAdviceReply implements Serializable {
    /** ID */
    @TableId(value = "id", type = IdType.AUTO)
    protected Long id;
    /** 反馈建议ID */
    @TableField("advice_id")
    protected Long adviceId;
    /** 回复来源(1-用户;2-平台) */
    @TableField("reply_source")
    protected Integer replySource;
    /** 平台用户ID */
    @TableField("user_id")
    protected Long userId;
    /** 回复内容 */
    @TableField("content")
    protected String content;
    /** 图片链接 */
    @TableField("image")
    protected String image;
    /** 创建时间 */
    @TableField("create_time")
    protected Date createTime;
}
