package com.icetech.city.road.domain.table;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import java.util.Date;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 商户优惠模板表
 * </p>
 *
 * @author wangzhiwei
 * @since 2021-04-22
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("ice_merchant_discount")
public class MerchantDiscount implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 停车场id
     */
    private Integer parkId;

    /**
     * 商户id
     */
    private Integer merchantId;

    /**
     * 模板编号
     */
    private String code;

    /**
     * 优惠券名称
     */
    private String name;

    /**
     * 优惠类型1全免2减免时间3减免金额4折扣5按天优免
     */
    private Integer type;

    /**
     * 优惠数额
     */
    private String amount;

    /**
     * 商家扣除余额类型：优惠类型为1时，1：按时长计费后扣除，2按金额(元)扣除；当优惠类型为4时，1：按计费折算后扣除，2按金额(元)扣除；
     */
    private Boolean deductType;

    /**
     * 单张优惠扣除金额（元）
     */
    private BigDecimal deductMoney;

    /**
     * 单张优惠扣除金额（元）
     */
    private BigDecimal timerType;

    /**
     * 发放限制：1：任意领取；2：自然天内只能领取一次；3：固定时间内只能领取一次
     */
    private Integer sendType;

    /**
     * send_type== 3时分钟数
     */
    private Integer timeNum;

    /**
     * 有效期开始时间
     */
    private Date startTime;

    /**
     * 有效期结束时间
     */
    private Date endTime;

    private String remark;

    /**
     * 状态，0：正常，1：删除
     */
    private Boolean status;

    /**
     * 创建人
     */
    private String operAccount;

    /**
     * 修改人
     */
    private String updateUser;

    private LocalDateTime createTime;

    private LocalDateTime updateTime;


}
