package com.icetech.city.road.domain.table;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.LocalTime;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.icetech.city.road.component.jackson.TemporalFormat;
import com.icetech.city.road.utils.DateUtils;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
@TableName("ice_empe_atte_class")
public class EmpeAtteClass implements Serializable {
    /** ID */
    @TableId("id")
    protected Long id;
    /** 分组ID */
    @TableField(value = "group_id", updateStrategy = FieldStrategy.NEVER)
    protected Long groupId;
    /** 班次名称 */
    @TableField("class_name")
    protected String className;
    /** 开始时间 */
    @TableField("begin_time")
    @JsonFormat(pattern = DateUtils.DEFAULT_TIME_HM_PATTERN)
    @TemporalFormat(pattern = DateUtils.DEFAULT_TIME_HM_PATTERN)
    protected LocalTime beginTime;
    /** 结束时间 */
    @TableField("end_time")
    @JsonFormat(pattern = DateUtils.DEFAULT_TIME_HM_PATTERN)
    @TemporalFormat(pattern = DateUtils.DEFAULT_TIME_HM_PATTERN)
    protected LocalTime endTime;
    /** 提前签到时间(秒, -1表示空值) */
    @TableField(value = "come_early_duration")
    protected Integer comeEarlyDuration;
    /** 延后签到时间(秒, -1表示空值) */
    @TableField(value = "come_delay_duration")
    protected Integer comeDelayDuration;
    /** 迟到时间(秒, -1表示空值) */
    @TableField(value = "come_late_duration")
    protected Integer comeLateDuration;
    /** 早退时间(秒, -1表示空值) */
    @TableField(value = "leave_early_duration")
    protected Integer leaveEarlyDuration;
    /** 启用考勤距离范围(0/1) */
    @TableField("check_dist_range_flag")
    protected Integer checkDistRangeFlag;
    /** 考勤距离范围(米, -1表示空值) */
    @TableField(value = "check_dist_range")
    protected Integer checkDistRange;
    /** 启用标识(0/1) */
    @TableField("enable_flag")
    protected Integer enableFlag;
    /** 创建人 */
    @TableField(value = "create_user", updateStrategy = FieldStrategy.NEVER)
    protected String createUser;
    /** 创建时间 */
    @TableField(value = "create_time", updateStrategy = FieldStrategy.NEVER)
    @JsonFormat(pattern = DateUtils.DEFAULT_DATETIME_PATTERN)
    @TemporalFormat(pattern = DateUtils.DEFAULT_DATETIME_PATTERN)
    protected LocalDateTime createTime;
    /** 修改人 */
    @TableField("update_user")
    protected String updateUser;
    /** 修改时间 */
    @TableField("update_time")
    @JsonFormat(pattern = DateUtils.DEFAULT_DATETIME_PATTERN)
    @TemporalFormat(pattern = DateUtils.DEFAULT_DATETIME_PATTERN)
    protected LocalDateTime updateTime;
}
