package com.icetech.city.road.domain.table;

import java.io.Serializable;
import java.time.LocalDateTime;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.NoArgsConstructor;

/** 设备推送记录 */
@Data
@NoArgsConstructor
@TableName("ice_device_push_record")
public class DevicePushRecord implements Serializable {
    /** _id */
    @TableId(type = IdType.AUTO)
    protected Long id;
    protected String recordId;
    /** 道路ID */
    protected Long parkId;
    /** 泊位ID */
    protected Long berthId;
    /** 订单号 */
    protected String orderNum;
    /** 业务ID */
    protected String dataId;
    /** 推送类型(0-其他;1-入场;2-离场;3-支付;4-文件;) */
    protected Integer pushType;
    /**
     * <p>推送源(0-系统平台;1-高位视频;2-地磁;3-pos机;4-人工手动;5-巡检车)</p>
     * <p>参考{@link com.icetech.city.road.domain.table.Order#getEnterWay()}</p>
     * <p>参考{@link com.icetech.city.road.domain.table.Order#getExitWay()}</p>
     */
    protected Integer pushSource;
    /** 推送目标 */
    protected String pushTarget;
    /** 推送目的地 */
    protected String pushDest;
    /** 推送内容 */
    protected String pushContent;
    /** 响应内容 */
    protected String respContent;
    /** 推送结果(0:推送中;1:成功;2:失败) */
    protected Integer pushResult;
    /** 推送备注 */
    protected String pushDesc;
    /** 推送时间(Unix时间戳/毫秒) */
    protected LocalDateTime pushTime;

    public DevicePushRecord(long parkId, long berthId, String orderNum, int pushType, int pushSource, String pushTarget, String pushDest, String pushContent) {
        setParkId(parkId);
        setBerthId(berthId);
        setOrderNum(orderNum);
        setPushType(pushType);
        setPushSource(pushSource);
        setPushTarget(pushTarget);
        setPushDest(pushDest);
        setPushContent(pushContent);
        setPushTime(LocalDateTime.now());
    }
}
